!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Apr 28, 2019 by M. Shiga
!      Description:     polymers main routine
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine main_polymers_MPI
!***********************************************************************
!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use cons_variables, only : ncons

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

!-----------------------------------------------------------------------
!     /*   option                                                     */
!-----------------------------------------------------------------------

      if ( ncons .eq. 0 ) then

         call main_polymers_atom_MPI

      else

         call main_polymers_cons_MPI

      end if

      return
      end





!***********************************************************************
      subroutine main_polymers_atom_MPI
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

!     /*   shared variables   */
      use common_variables, only : iexit

      use polymers_variables, only : &
     &   icycle_poly, icycle_poly_start, icycle_poly_end, ncycle_poly

!-----------------------------------------------------------------------
!     /*   first cycle                                                */
!-----------------------------------------------------------------------

!     /*   initial cycle   */
      icycle_poly = icycle_poly_start
      icycle_poly_end = icycle_poly

!     /*   align centroid   */
      call align_polymers_atom_MPI

!     /*   run pimd for all polymers   */
      call run_polymers_atom_MPI

!     /*   exit if `exit.dat' exists   */
      if ( iexit .eq. 1 ) go to 100

!     /*   calculate centroid potential of mean force   */
      call pmfc_polymers_atom_MPI

!     /*   standard output   */
      call print_polymers_atom_MPI

!-----------------------------------------------------------------------
!     /*   loop of cycles                                             */
!-----------------------------------------------------------------------

      do icycle_poly = icycle_poly_start+1, ncycle_poly

!        /*   current cycle   */
         icycle_poly_end = icycle_poly

!        /*   update centroid   */
         call projection_polymers_atom_MPI

!        /*   update centroid   */
         call update_polymers_atom_MPI

!        /*   align centroid   */
         call align_polymers_atom_MPI

!        /*   run pimd for all polymers   */
         call run_polymers_atom_MPI

!        /*   exit if `exit.dat' exists   */
         if ( iexit .eq. 1 ) exit

!c        /*   soft exit   */
!         call softexit_MPI
!         if ( iexit .eq. 1 ) exit

!        /*   calculate centroid potential of mean force   */
         call pmfc_polymers_atom_MPI

!        /*   standard output   */
         call print_polymers_atom_MPI

      end do

!     /*   continue   */
  100 continue

!     /*   last cycle   */
      icycle_poly = icycle_poly_end

!     /*   print polycycle.ini   */
      call finalize_polymers_MPI

      return
      end





!***********************************************************************
      subroutine main_polymers_cons_MPI
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

!     /*   shared variables   */
      use common_variables, only : iexit

      use polymers_variables, only : &
     &   icycle_poly, icycle_poly_start, icycle_poly_end, ncycle_poly

!-----------------------------------------------------------------------
!     /*   first cycle                                                */
!-----------------------------------------------------------------------

!     /*   initial cycle   */
      icycle_poly = icycle_poly_start
      icycle_poly_end = icycle_poly

!     /*   align centroid   */
      call align_polymers_cons_MPI( 0 )

!     /*   run pimd for all polymers   */
      call run_polymers_cons_MPI

!     /*   exit if `exit.dat' exists   */
      if ( iexit .eq. 1 ) go to 100

!     /*   calculate centroid potential of mean force   */
!         call pmfc_polymers_cons_MPI
         call pmfc_polymers_cons_revised_MPI

!     /*   standard output   */
      call print_polymers_cons_MPI

!-----------------------------------------------------------------------
!     /*   loop of cycles                                             */
!-----------------------------------------------------------------------

      do icycle_poly = icycle_poly_start+1, ncycle_poly

!        /*   current cycle   */
         icycle_poly_end = icycle_poly

!        /*   update centroid   */
         call update_polymers_cons_MPI

!        /*   align centroid   */
         call align_polymers_cons_MPI( 0 )

!        /*   run pimd for all polymers   */
         call run_polymers_cons_MPI

!        /*   exit if `exit.dat' exists   */
         if ( iexit .eq. 1 ) exit

!c        /*   soft exit   */
!         call softexit_MPI
!         if ( iexit .eq. 1 ) exit

!        /*   calculate centroid potential of mean force   */
         call pmfc_polymers_cons_MPI
!         call pmfc_polymers_cons_revised_MPI

!        /*   standard output   */
         call print_polymers_cons_MPI

      end do

!     /*   continue   */
  100 continue

!     /*   last cycle   */
      icycle_poly = icycle_poly_end

!     /*   print polycycle.ini   */
      call finalize_polymers_MPI

      return
      end
