!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Feb 1, 2025 by M. Shiga
!      Description:     main routine of PIMD
!
!///////////////////////////////////////////////////////////////////////
!+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
!
!      PIMD version 2.7.1
!
!      Author:        M. Shiga
!
!      Last Updated:  Jan 8, 2026.
!
!      Copyright(C) 2016-2026  M. Shiga  All rights reserved.
!
!      Licensed under the Apache License, Version 2.0 (the "License");
!      you may not use this file except in compliance with the License.
!      You may obtain a copy of the License at
!
!      http://www.apache.org/licenses/LICENSE-2.0
!
!      Unless required by applicable law or agreed to in writing,
!      software distributed under the License is distributed on an
!      "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
!      either express or implied. See the License for the specific
!      language governing permissions and limitations under the License.
!
!+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
!***********************************************************************
      program main_calc
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

!-----------------------------------------------------------------------
!     /*   print titles                                               */
!-----------------------------------------------------------------------

      call print_titles_calc

!-----------------------------------------------------------------------
!     /*   set parameters                                             */
!-----------------------------------------------------------------------

      call setparams_calc

!-----------------------------------------------------------------------
!     /*   memory allocation                                          */
!-----------------------------------------------------------------------

      call setallocation_calc

!-----------------------------------------------------------------------
!     /*   prepare condition                                          */
!-----------------------------------------------------------------------

      call setcondition_calc

!-----------------------------------------------------------------------
!     /*  post run analysis                                           */
!-----------------------------------------------------------------------

      call setup_calc

!-----------------------------------------------------------------------
!     /*  post run analysis                                           */
!-----------------------------------------------------------------------

      call calccycle

!-----------------------------------------------------------------------
!     /*   print                                                      */
!-----------------------------------------------------------------------

      write(6,'(a)') 'Normal termination of calc.'
      write(6,'(a)')

      stop
      end





!***********************************************************************
      subroutine print_titles_calc
!***********************************************************************

      implicit none

      write(6,'(a)')

      write(6,'(a)') &
     &   '++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++' &
     &   // '++++++++++++++++++'
      write(6,'(a)')

      write(6,'(a)') &
     &   'CALC version 2.6.1'
      write(6,'(a)')

      write(6,'(a)') &
     &   'Author:        M. Shiga'
      write(6,'(a)')

      write(6,'(a)') &
     &   'Last Updated:  Jan 4, 2024.'
      write(6,'(a)')

      write(6,'(a)') &
     &   'Copyright(C) 2016-2024  M. Shiga  All rights reserved.'
      write(6,'(a)')

      write(6,'(a)') &
     &   'Licensed under the Apache License, Version 2.0' // &
     &   ' (the "License");'
      write(6,'(a)') &
     &   'you may not use this file except in compliance' // &
     &   ' with the License.'
      write(6,'(a)') &
     &   'You may obtain a copy of the License at'
      write(6,'(a)') &
     &   ''
      write(6,'(a)') &
     &   'http://www.apache.org/licenses/LICENSE-2.0'
      write(6,'(a)') &
     &   ''
      write(6,'(a)') &
     &   'Unless required by applicable law or agreed to in' // &
     &   ' writing, software'
      write(6,'(a)') &
     &   'distributed under the License is distributed on an' // &
     &   ' "AS IS" BASIS,'
      write(6,'(a)') &
     &   'WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either' // &
     &   ' express or implied.'
      write(6,'(a)') &
     &   'See the License for the specific language governing' // &
     &   ' permissions and'
      write(6,'(a)') &
     &   'limitations under the License.'
      write(6,'(a)')

      write(6,'(a)') &
     &   '++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++' &
     &   // '++++++++++++++++++'
      write(6,'(a)')

      return
      end
