!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Nov 10, 2018 by M. Shiga
!      Description:     calculation of kinetic energy
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine kinetic_energy
!***********************************************************************
!=======================================================================
!
!     calculate ekin = fictitious kinetic energy of the system
!
!=======================================================================

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   ekin, fictmass, vux, vuy, vuz, ekin, natom, nbead

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer :: imode, iatom

!-----------------------------------------------------------------------
!     /*   start                                                      */
!-----------------------------------------------------------------------

      ekin = 0.d0

      do imode = 1, nbead
      do iatom = 1, natom
         ekin = ekin &
     &        + fictmass(iatom,imode)*vux(iatom,imode)*vux(iatom,imode) &
     &        + fictmass(iatom,imode)*vuy(iatom,imode)*vuy(iatom,imode) &
     &        + fictmass(iatom,imode)*vuz(iatom,imode)*vuz(iatom,imode)
      end do
      end do

      ekin = 0.5d0*ekin

      return
      end

