!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Dec 18, 2020 by M. Shiga
!      Description:     acceptance in path integral hybrid Monte Carlo
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine judge_fourth_hmc_nvt_MPI
!***********************************************************************
!=======================================================================
!
!     metropolis step for hybrid monte carlo.
!
!=======================================================================

!     /*   shared variables   */
      use common_variables, only : &
     &   beta, x, y, z, fx, fy, fz, pot, box, iboundary, ipotential, &
     &   myrank

!     /*   shared variables   */
      use hmc_variables, only : &
     &   hamiltonian_hmc, hamiltonian_hmc_save, ratio, bfactor, &
     &   x_hmc_last, y_hmc_last, z_hmc_last, pot_hmc_last, box_hmc_last, &
     &   fx_hmc_last, fy_hmc_last, fz_hmc_last, box_save, &
     &   naccept, nreject

!     /*   local variables   */
      implicit none

!     /*   local variables   */
      real(8) :: ranf1, randomno, det3

!     /*   option   */
      integer :: ioption = 0

!-----------------------------------------------------------------------

      x_hmc_last(:,:) = x(:,:)
      y_hmc_last(:,:) = y(:,:)
      z_hmc_last(:,:) = z(:,:)

      pot_hmc_last(:) = pot(:)

      fx_hmc_last(:,:) = fx(:,:)
      fy_hmc_last(:,:) = fy(:,:)
      fz_hmc_last(:,:) = fz(:,:)

      box_hmc_last(:,:) = box(:,:)

!-----------------------------------------------------------------------

      bfactor = beta *( hamiltonian_hmc - hamiltonian_hmc_save )

      if ( ioption .eq. 1 ) then
      if ( ( iboundary .eq. 1 ) .or. ( iboundary .eq. 2 ) ) then
         bfactor = bfactor - 2.d0 * log( det3(box) / det3(box_save) )
      end if
      end if

      if ( ipotential(1:5) .eq. 'DUAL ' ) call correct_dual_bfactor

      if ( bfactor .lt. 75.d0 ) then

         if ( bfactor .le. 0.d0 ) then

!           /*   accepted   */
            naccept = naccept + 1

         else

            if ( myrank .eq. 0 ) then
               randomno = ranf1()
            end if

            call my_mpi_bcast_real_0( randomno )

            if ( exp(-bfactor) .gt. randomno ) then

!              /*   accepted   */
               naccept = naccept + 1

            else

!              /*   rejected   */
               nreject = nreject + 1

!              /*   recover saved data   */
               call recover_fourth_hmc_nvt_MPI

            end if

         end if

      else

!        /*   rejected   */
         nreject = nreject + 1

!        /*   recover saved data   */
         call recover_fourth_hmc_nvt_MPI

      end if

!     /*   acceptance ratio   */
      ratio = dble(naccept) / dble(naccept+nreject)

!-----------------------------------------------------------------------

!     /*   initialize velocity   */
      call nm_velocity_MPI

!     /*   energy   */
      call getenergy_fourth_hmc_nvt_MPI

!     /*   save data   */
      call save_fourth_hmc_nvt

!-----------------------------------------------------------------------

      return
      end





!***********************************************************************
      subroutine judge_fourth_hmc_npt_c1_MPI
!***********************************************************************
!=======================================================================
!
!     metropolis step for hybrid monte carlo.
!
!=======================================================================

!     /*   shared variables   */
      use common_variables, only : &
     &   beta, x, y, z, fx, fy, fz, pot, box, iboundary, ipotential, &
     &   myrank

!     /*   shared variables   */
      use hmc_variables, only : &
     &   hamiltonian_hmc, hamiltonian_hmc_save, ratio, bfactor, &
     &   x_hmc_last, y_hmc_last, z_hmc_last, pot_hmc_last, box_hmc_last, &
     &   fx_hmc_last, fy_hmc_last, fz_hmc_last, box_save, &
     &   naccept, nreject

!     /*   local variables   */
      implicit none

!     /*   local variables   */
      real(8) :: ranf1, randomno, det3

!     /*   option   */
      integer :: ioption = 0

!-----------------------------------------------------------------------

      x_hmc_last(:,:) = x(:,:)
      y_hmc_last(:,:) = y(:,:)
      z_hmc_last(:,:) = z(:,:)

      pot_hmc_last(:) = pot(:)

      fx_hmc_last(:,:) = fx(:,:)
      fy_hmc_last(:,:) = fy(:,:)
      fz_hmc_last(:,:) = fz(:,:)

      box_hmc_last(:,:) = box(:,:)

!-----------------------------------------------------------------------

      bfactor = beta *( hamiltonian_hmc - hamiltonian_hmc_save )

      if ( ioption .eq. 1 ) then
      if ( ( iboundary .eq. 1 ) .or. ( iboundary .eq. 2 ) ) then
         bfactor = bfactor - 2.d0 * log( det3(box) / det3(box_save) )
      end if
      end if

      if ( ipotential(1:5) .eq. 'DUAL ' ) call correct_dual_bfactor

      if ( bfactor .lt. 75.d0 ) then

         if ( bfactor .le. 0.d0 ) then

!           /*   accepted   */
            naccept = naccept + 1

         else

            if ( myrank .eq. 0 ) then
               randomno = ranf1()
            end if

            call my_mpi_bcast_real_0( randomno )

            if ( exp(-bfactor) .gt. randomno ) then

!              /*   accepted   */
               naccept = naccept + 1

            else

!              /*   rejected   */
               nreject = nreject + 1

!              /*   recover saved data   */
               call recover_fourth_hmc_npt_MPI

            end if

         end if

      else

!        /*   rejected   */
         nreject = nreject + 1

!        /*   recover saved data   */
         call recover_fourth_hmc_npt_MPI

      end if

!     /*   acceptance ratio   */
      ratio = dble(naccept) / dble(naccept+nreject)

!-----------------------------------------------------------------------

!     /*   initialize velocity   */
      call nm_velocity_MPI

!     /*   initialize velocity   */
      call init_box_velocity_MPI

!     /*   energy   */
      call getenergy_fourth_hmc_npt_c1_MPI

!     /*   save data   */
      call save_fourth_hmc_npt

!-----------------------------------------------------------------------

      return
      end





!***********************************************************************
      subroutine judge_fourth_hmc_npt_c2_MPI
!***********************************************************************
!=======================================================================
!
!     metropolis step for hybrid monte carlo.
!
!=======================================================================

!     /*   shared variables   */
      use common_variables, only : &
     &   beta, x, y, z, fx, fy, fz, pot, box, iboundary, ipotential, &
     &   myrank

!     /*   shared variables   */
      use hmc_variables, only : &
     &   hamiltonian_hmc, hamiltonian_hmc_save, ratio, bfactor, &
     &   x_hmc_last, y_hmc_last, z_hmc_last, pot_hmc_last, box_hmc_last, &
     &   fx_hmc_last, fy_hmc_last, fz_hmc_last, box_save, &
     &   naccept, nreject

!     /*   local variables   */
      implicit none

!     /*   local variables   */
      real(8) :: ranf1, randomno, det3

!     /*   option   */
      integer :: ioption = 0

!-----------------------------------------------------------------------

      x_hmc_last(:,:) = x(:,:)
      y_hmc_last(:,:) = y(:,:)
      z_hmc_last(:,:) = z(:,:)

      pot_hmc_last(:) = pot(:)

      fx_hmc_last(:,:) = fx(:,:)
      fy_hmc_last(:,:) = fy(:,:)
      fz_hmc_last(:,:) = fz(:,:)

      box_hmc_last(:,:) = box(:,:)

!-----------------------------------------------------------------------

      bfactor = beta *( hamiltonian_hmc - hamiltonian_hmc_save )

      if ( ioption .eq. 1 ) then
      if ( ( iboundary .eq. 1 ) .or. ( iboundary .eq. 2 ) ) then
         bfactor = bfactor - 2.d0 * log( det3(box) / det3(box_save) )
      end if
      end if

      if ( ipotential(1:5) .eq. 'DUAL ' ) call correct_dual_bfactor

      if ( bfactor .lt. 75.d0 ) then

         if ( bfactor .le. 0.d0 ) then

!           /*   accepted   */
            naccept = naccept + 1

         else

            if ( myrank .eq. 0 ) then
               randomno = ranf1()
            end if

            call my_mpi_bcast_real_0( randomno )

            if ( exp(-bfactor) .gt. randomno ) then

!              /*   accepted   */
               naccept = naccept + 1

            else

!              /*   rejected   */
               nreject = nreject + 1

!              /*   recover saved data   */
               call recover_fourth_hmc_npt_MPI

            end if

         end if

      else

!        /*   rejected   */
         nreject = nreject + 1

!        /*   recover saved data   */
         call recover_fourth_hmc_npt_MPI

      end if

!     /*   acceptance ratio   */
      ratio = dble(naccept) / dble(naccept+nreject)

!-----------------------------------------------------------------------

!     /*   initialize velocity   */
      call nm_velocity_MPI

!     /*   initialize velocity   */
      call init_box_velocity_MPI

!     /*   energy   */
      call getenergy_fourth_hmc_npt_c2_MPI

!     /*   save data   */
      call save_fourth_hmc_npt

!-----------------------------------------------------------------------

      return
      end





!***********************************************************************
      subroutine judge_fourth_hmc_npt_pp_MPI
!***********************************************************************
!=======================================================================
!
!     metropolis step for hybrid monte carlo.
!
!=======================================================================

!     /*   shared variables   */
      use common_variables, only : &
     &   beta, x, y, z, fx, fy, fz, pot, box, iboundary, ipotential, &
     &   myrank

!     /*   shared variables   */
      use hmc_variables, only : &
     &   hamiltonian_hmc, hamiltonian_hmc_save, ratio, bfactor, &
     &   x_hmc_last, y_hmc_last, z_hmc_last, pot_hmc_last, box_hmc_last, &
     &   fx_hmc_last, fy_hmc_last, fz_hmc_last, box_save, &
     &   naccept, nreject

!     /*   local variables   */
      implicit none

!     /*   local variables   */
      real(8) :: ranf1, randomno, det3

!     /*   option   */
      integer :: ioption = 0

!-----------------------------------------------------------------------

      x_hmc_last(:,:) = x(:,:)
      y_hmc_last(:,:) = y(:,:)
      z_hmc_last(:,:) = z(:,:)

      pot_hmc_last(:) = pot(:)

      fx_hmc_last(:,:) = fx(:,:)
      fy_hmc_last(:,:) = fy(:,:)
      fz_hmc_last(:,:) = fz(:,:)

      box_hmc_last(:,:) = box(:,:)

!-----------------------------------------------------------------------

      bfactor = beta *( hamiltonian_hmc - hamiltonian_hmc_save )

      if ( ioption .eq. 1 ) then
      if ( ( iboundary .eq. 1 ) .or. ( iboundary .eq. 2 ) ) then
         bfactor = bfactor - 2.d0 * log( det3(box) / det3(box_save) )
      end if
      end if

      if ( ipotential(1:5) .eq. 'DUAL ' ) call correct_dual_bfactor

      if ( bfactor .lt. 75.d0 ) then

         if ( bfactor .le. 0.d0 ) then

!           /*   accepted   */
            naccept = naccept + 1

         else

            if ( myrank .eq. 0 ) then
               randomno = ranf1()
            end if

            call my_mpi_bcast_real_0( randomno )

            if ( exp(-bfactor) .gt. randomno ) then

!              /*   accepted   */
               naccept = naccept + 1

            else

!              /*   rejected   */
               nreject = nreject + 1

!              /*   recover saved data   */
               call recover_fourth_hmc_npt_MPI

            end if

         end if

      else

!        /*   rejected   */
         nreject = nreject + 1

!        /*   recover saved data   */
         call recover_fourth_hmc_npt_MPI

      end if

!     /*   acceptance ratio   */
      ratio = dble(naccept) / dble(naccept+nreject)

!-----------------------------------------------------------------------

!     /*   initialize velocity   */
      call nm_velocity_MPI

!     /*   initialize velocity   */
      call init_box_velocity_MPI

!     /*   energy   */
      call getenergy_fourth_hmc_npt_pp_MPI

!     /*   save data   */
      call save_fourth_hmc_npt

!-----------------------------------------------------------------------

      return
      end





!***********************************************************************
      subroutine judge_fourth_hmc_ntt_pp_MPI
!***********************************************************************
!=======================================================================
!
!     metropolis step for hybrid monte carlo.
!
!=======================================================================

!     /*   shared variables   */
      use common_variables, only : &
     &   beta, x, y, z, fx, fy, fz, pot, box, iboundary, ipotential, &
     &   myrank

!     /*   shared variables   */
      use hmc_variables, only : &
     &   hamiltonian_hmc, hamiltonian_hmc_save, ratio, bfactor, &
     &   x_hmc_last, y_hmc_last, z_hmc_last, pot_hmc_last, box_hmc_last, &
     &   fx_hmc_last, fy_hmc_last, fz_hmc_last, box_save, &
     &   naccept, nreject

!     /*   local variables   */
      implicit none

!     /*   local variables   */
      real(8) :: ranf1, randomno, det3

!     /*   option   */
      integer :: ioption = 0

!-----------------------------------------------------------------------

      x_hmc_last(:,:) = x(:,:)
      y_hmc_last(:,:) = y(:,:)
      z_hmc_last(:,:) = z(:,:)

      pot_hmc_last(:) = pot(:)

      fx_hmc_last(:,:) = fx(:,:)
      fy_hmc_last(:,:) = fy(:,:)
      fz_hmc_last(:,:) = fz(:,:)

      box_hmc_last(:,:) = box(:,:)

!-----------------------------------------------------------------------

      bfactor = beta *( hamiltonian_hmc - hamiltonian_hmc_save )

      if ( ioption .eq. 1 ) then
      if ( ( iboundary .eq. 1 ) .or. ( iboundary .eq. 2 ) ) then
         bfactor = bfactor - 2.d0 * log( det3(box) / det3(box_save) )
      end if
      end if

      if ( ipotential(1:5) .eq. 'DUAL ' ) call correct_dual_bfactor

      if ( bfactor .lt. 75.d0 ) then

         if ( bfactor .le. 0.d0 ) then

!           /*   accepted   */
            naccept = naccept + 1

         else

            if ( myrank .eq. 0 ) then
               randomno = ranf1()
            end if

            call my_mpi_bcast_real_0( randomno )

            if ( exp(-bfactor) .gt. randomno ) then

!              /*   accepted   */
               naccept = naccept + 1

            else

!              /*   rejected   */
               nreject = nreject + 1

!              /*   recover saved data   */
               call recover_fourth_hmc_ntt_MPI

            end if

         end if

      else

!        /*   rejected   */
         nreject = nreject + 1

!        /*   recover saved data   */
         call recover_fourth_hmc_ntt_MPI

      end if

!     /*   acceptance ratio   */
      ratio = dble(naccept) / dble(naccept+nreject)

!-----------------------------------------------------------------------

!     /*   initialize velocity   */
      call nm_velocity_MPI

!     /*   initialize velocity   */
      call init_box_velocity_MPI

!     /*   energy   */
      call getenergy_fourth_hmc_ntt_pp_MPI

!     /*   save data   */
      call save_fourth_hmc_ntt

!-----------------------------------------------------------------------

      return
      end

