#include <stdio.h>
#include <dirent.h>
#include <sys/stat.h>
#include <regex.h>
#include <string.h>


int get_numberoffiles_c(const char *string)
{
    DIR *dir;
    struct dirent *dent;
    dir = opendir(string);
    if (dir == NULL) {
        perror(string);
        return 1;
    }
    int count = 0;
    while ((dent = readdir(dir)) != NULL) {
        count = count + 1;
    }

    closedir(dir);
    return count;
}

int mkdir_c(const char *string)
{
    int i;
    i = mkdir(string,S_IRUSR | S_IWUSR | S_IXUSR | 
                S_IRGRP | S_IWGRP | S_IXGRP |  
                S_IROTH | S_IXOTH | S_IXOTH);

    return i;
}



int regex_c(const char *pattern,const char *string)
{
    int i;
    int  errcode;
    regex_t preg;

    errcode = regcomp(&preg, pattern, REG_EXTENDED|REG_NEWLINE);

    //printf("string is  %s\n", string);

    size_t     nmatch = 2;
    regmatch_t pmatch[2];

    int eflags = 0;
    int rc;

    rc = regexec(&preg, string, nmatch, pmatch, 0) ;

    /*
    if (0 != (rc = regexec(&preg, string, nmatch, pmatch, 0))) {
      printf("Failed to match '%s' with '%s',returning %d.\n",
          string, pattern, rc);
    }
    else {
      printf("With the whole expression, "
             "a matched substring \"%.*s\" is found at position %d to %d.\n",
             pmatch[0].rm_eo - pmatch[0].rm_so, &string[pmatch[0].rm_so],
             pmatch[0].rm_so, pmatch[0].rm_eo - 1);
      printf("With the sub-expression, "
             "a matched substring \"%.*s\" is found at position %d to %d.\n",
             pmatch[1].rm_eo - pmatch[1].rm_so, &string[pmatch[1].rm_so],
             pmatch[1].rm_so, pmatch[1].rm_eo - 1);
   }
   */
   

    regfree(&preg);



    
    return rc;
}

void remove_all(const char *pattern,const char *string) //int *numStrings,char **stringArray)
{
    int i;
    int rc;

    char buff[256];    /* 連結文字列用 */
    char buff1[256];   /* 入力文字列用 */
    char buff2[256];   /* 入力文字列用 */

    
    //strcat(buff, buff2);

    //printf("%s\n",pattern);

    DIR *dir;
    struct dirent *dent;
    dir = opendir(string);
    if (dir == NULL) {
        perror(string);
    }
    int count = 0;
    while ((dent = readdir(dir)) != NULL) {
        count = count + 1;
        

        if (0 != regex_c(pattern,dent->d_name)){
        }else
        {
            strcpy(buff, string);  /* 文字列コピー(buff$ = buff1$) */
            strcat(buff, "/");
            strcat(buff, dent->d_name);
            printf("buff %s\n",buff);
            //printf("%s\n",dent->d_name);
            rc = remove(buff);
        }
    }

    closedir(dir);

}



void get_filenames_c(const char *string,int *numStrings,char* stringArray[])
{
    DIR *dir;
    struct dirent *dent;
    dir = opendir(string);
    if (dir == NULL) {
        perror(string);
    }
    int i;
    for(i=0;i<*numStrings;++i) {
       dent = readdir(dir);
       strcpy(stringArray[i], dent->d_name);
//       printf("%s\n",stringArray[i]);
    } 

    closedir(dir);

}

int directory_exists(const char *path)
{
    struct stat st;
    if (stat(path, &st) != 0)
    {
        // Error occurred, probaly path does not exist
        return 0; 
    }
    return S_ISDIR(st.st_mode);
}

