!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Nov 10, 2018 by M. Shiga
!      Description:     input and output of geometry
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine iogeometry ( ioption, char_file, length_file, iounit, &
     &                        x, y, z, natom, nbead )
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer :: i, ioption, iounit, j, length_file, natom, nbead

      integer :: idummy

      character(len=length_file) :: char_file

      real(8):: x(natom,nbead)
      real(8):: y(natom,nbead)
      real(8):: z(natom,nbead)

!-----------------------------------------------------------------------
!     /*   start                                                      */
!-----------------------------------------------------------------------

      if ( ioption .eq. 1 ) then

         open ( iounit, file = char_file(1:length_file) )

         do j = 1, nbead
         do i = 1, natom
            write( iounit, '(i8,6e24.16,3i4)' ) &
     &         1, x(i,j), y(i,j), z(i,j), 0.d0, 0.d0, 0.d0, 0, 0, 0
         end do
         end do

         close ( iounit )

      else if ( ioption .eq. 2 ) then

         open ( iounit, file = char_file(1:length_file) )

         do j = 1, nbead
         do i = 1, natom
            read ( iounit, * ) &
     &         idummy, x(i,j), y(i,j), z(i,j)
         end do
         end do

         close ( iounit )

      end if

      return
      end

