!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Nov 10, 2018 by M. Shiga
!      Description:     input and output of energy and force
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine ioforce ( ioption, char_file, length_file, iounit, &
     &                     pot, fx, fy, fz, natom, nbead )
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer :: i, j, ioption, length_file, iounit, natom, nbead

      real(8) :: fxn, fyn, fzn

      character(len=80) :: char_file

      real(8):: pot(nbead)

      real(8):: fx(natom,nbead)
      real(8):: fy(natom,nbead)
      real(8):: fz(natom,nbead)

!-----------------------------------------------------------------------
!     /*   start                                                      */
!-----------------------------------------------------------------------

      if ( ioption .eq. 1 ) then

         open ( iounit, file = char_file(1:length_file) )

         do j = 1, nbead
            write(iounit,'(e24.16)') pot(j)
         end do

         do j = 1, nbead
         do i = 1, natom

            fxn = fx(i,j)*nbead
            fyn = fy(i,j)*nbead
            fzn = fz(i,j)*nbead

            write(iounit,'(3e24.16)') fxn, fyn, fzn

         end do
         end do

         close ( iounit )

      else if ( ioption .eq. 2 ) then

         open ( iounit, file = char_file(1:length_file) )

         do j = 1, nbead
            read (iounit,*) pot(j)
         end do

         do j = 1, nbead
         do i = 1, natom

            read (iounit,*) fxn, fyn, fzn

            fx(i,j) = fxn/nbead
            fy(i,j) = fyn/nbead
            fz(i,j) = fzn/nbead

         end do
         end do

         close ( iounit )

      end if

      return
      end





!***********************************************************************
      subroutine iodipole( ioption, char_file, length_file, iounit, &
     &                     dipx, dipy, dipz, nbead )
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer :: j, ioption, length_file, iounit, nbead, idummy, ierr

      character(len=length_file) :: char_file

      real(8):: dipx(nbead)
      real(8):: dipy(nbead)
      real(8):: dipz(nbead)

!-----------------------------------------------------------------------
!     /*   start                                                      */
!-----------------------------------------------------------------------

      if ( ioption .eq. 1 ) then

         open ( iounit, file = char_file(1:length_file) )

         do j = 1, nbead
            write( iounit, '(i8,3f12.5)' ) &
     &         1, dipx(j), dipy(j), dipz(j)
         end do

         close ( iounit )

      else if ( ioption .eq. 2 ) then

         open ( iounit, file = char_file(1:length_file) )

         do j = 1, nbead
            read ( iounit, *, iostat=ierr ) &
     &         idummy, dipx(j), dipy(j), dipz(j)
         end do

         close ( iounit )

      end if

      return
      end





!***********************************************************************
      subroutine iovirial ( ioption, char_file, length_file, iounit, &
     &                      vir )
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer :: ioption, length_file, iounit

      character(len=80) :: char_file

      real(8):: vir(3,3)

!-----------------------------------------------------------------------
!     /*   start                                                      */
!-----------------------------------------------------------------------

      if ( ioption .eq. 1 ) then

         open ( iounit, file = char_file(1:length_file) )

         write(iounit,'(3e24.16)') vir(1,1), vir(1,2), vir(1,3)
         write(iounit,'(3e24.16)') vir(2,1), vir(2,2), vir(2,3)
         write(iounit,'(3e24.16)') vir(3,1), vir(3,2), vir(3,3)

         close ( iounit )

      else if ( ioption .eq. 2 ) then

         open ( iounit, file = char_file(1:length_file) )

         read (iounit,*) vir(1,1), vir(1,2), vir(1,3)
         read (iounit,*) vir(2,1), vir(2,2), vir(2,3)
         read (iounit,*) vir(3,1), vir(3,2), vir(3,3)

         close ( iounit )

      end if

      return
      end





!***********************************************************************
      subroutine iobox ( ioption, char_file, length_file, iounit, box )
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer :: ioption, length_file, iounit, k

      character(len=80) :: char_file

      real(8):: box(3,3)

!-----------------------------------------------------------------------
!     /*   start                                                      */
!-----------------------------------------------------------------------

      if ( ioption .eq. 1 ) then

         open ( iounit, file = char_file(1:length_file) )

         write(iounit,'(i8,3e24.16)') 1, box(1,1), box(1,2), box(1,3)
         write(iounit,'(i8,3e24.16)') 1, box(2,1), box(2,2), box(2,3)
         write(iounit,'(i8,3e24.16)') 1, box(3,1), box(3,2), box(3,3)

         close ( iounit )

      else if ( ioption .eq. 2 ) then

         open ( iounit, file = char_file(1:length_file) )

         read (iounit,*) k, box(1,1), box(1,2), box(1,3)
         read (iounit,*) k, box(2,1), box(2,2), box(2,3)
         read (iounit,*) k, box(3,1), box(3,2), box(3,3)

         close ( iounit )

      end if

      return
      end

