!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Nov 10, 2018 by M. Shiga
!      Description:     inverse of matrix
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine inv(a,ainv,n)
!***********************************************************************

!#######################################################################
#ifdef nolapack
!#######################################################################

!     //   initialize
      implicit none

!     //   dimension
      integer :: n

!     //   matrix
      real(8), dimension(n,n) :: a

!     //   inverse matrix
      real(8), dimension(n,n) :: ainv

!     //   error notice
      write( 6, '(a)' )
      write( 6, '(a)' ) 'Error - Matrix inversion routine not linked.'
      write( 6, '(a)' )

      call error_handling ( 1, 'subroutine inv', 14 )

!#######################################################################
#else
!#######################################################################

!     //   initialize
      implicit none

!     //   dimension
      integer :: n

!     //   error info
      integer :: info

!     //   matrix
      real(8), dimension(n,n) :: a

!     //   inverse matrix
      real(8), dimension(n,n) :: ainv

!     //   work arrays
      real(8), dimension(n) :: work
      integer, dimension(n) :: ipiv

!     //   external procedures defined in LAPACK
      external DGETRF
      external DGETRI

!     //   store a in ainv
      ainv(:,:) = a(:,:)

!     //   LU factorization
      call DGETRF(n, n, ainv, n, ipiv, info)

!     //  error notice
      if (info .ne. 0) then
         stop 'Matrix is numerically singular!'
      end if

!     //  inverse of a matrix using the LU factorization
      call DGETRI(n, ainv, n, ipiv, work, n, info)

!     //  error notice
      if (info .ne. 0) then
         stop 'Matrix inversion failed!'
      end if

!#######################################################################
#endif
!#######################################################################

      return
      end
