!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Dec 2, 2019 by M. Shiga
!      Description:     convert integer to character
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine int3_to_char( num, char_num )
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer :: j, num

      character(len=3) :: char_num

!-----------------------------------------------------------------------
!     /*   integer 7   ->   character '007'                           */
!-----------------------------------------------------------------------

      char_num = '   '

      write( char_num, '(i3)' ) num

      do j = 1, 3
          if ( char_num( j:j ) .eq. ' ' ) char_num( j:j ) = '0'
      end do

      return
      end


!***********************************************************************
      function int_to_char( num ) result(char_num)
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer :: j, num

      character(len=6) :: char_num

!-----------------------------------------------------------------------
!     /*   integer 7   ->   character '007'                           */
!-----------------------------------------------------------------------

      char_num = '      '

      write( char_num, '(i6)' ) num

      do j = 1, 6
          if ( char_num( j:j ) .eq. ' ' ) char_num( j:j ) = '0'
      end do

      end function int_to_char



!***********************************************************************
      subroutine int8_to_char( num, char_num )
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer :: j, num

      character(len=8) :: char_num

!-----------------------------------------------------------------------
!     /*   integer 7   ->   character '007'                           */
!-----------------------------------------------------------------------

      char_num = '   '

      write( char_num, '(i8)' ) num

      do j = 1, 8
          if ( char_num( j:j ) .eq. ' ' ) char_num( j:j ) = '0'
      end do

      return
      end


