!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Nov 10, 2018 by M. Shiga
!      Description:     initialize tass
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine init_bath_tass
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   xbath, ybath, zbath, vxbath, vybath, vzbath, qmass, beta, &
     &   natom, nbead, nnhc, ncolor

      use tass_variables, only : &
     &   rbath_tass, qmass_tass, vbath_tass, ntass

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer :: i, j, k, m

      real(8) :: vsigma, gasdev

!-----------------------------------------------------------------------
!     /*   thermostat attached to system                              */
!-----------------------------------------------------------------------

      do k = 1, nbead
      do j = 1, nnhc
      do i = 1, natom
         xbath(i,j,k) = 0.d0
         ybath(i,j,k) = 0.d0
         zbath(i,j,k) = 0.d0
      end do
      end do
      end do

      do k = 1, nbead
         vsigma = sqrt(1.d0/beta/qmass(k))
         do j = 1, nnhc
         do i = 1, natom
            vxbath(i,j,k) = vsigma*gasdev()
            vybath(i,j,k) = vsigma*gasdev()
            vzbath(i,j,k) = vsigma*gasdev()
         end do
         end do
      end do

!-----------------------------------------------------------------------
!     /*   thermostat attached to cv                                  */
!-----------------------------------------------------------------------

      rbath_tass(:,:,:,:) = 0.d0
      vbath_tass(:,:,:,:) = 0.d0

      do k = 1, nbead
      do m = 1, ncolor
      do j = 1, nnhc
      do i = 1, ntass
         vsigma = sqrt(1.d0/beta/qmass_tass(m))
         vbath_tass(i,j,m,k) = vsigma*gasdev()
      end do
      end do
      end do
      end do

      return
      end





!***********************************************************************
      subroutine init_cv_tass
!***********************************************************************
!=======================================================================
!
!     initialize cv for tass
!
!=======================================================================

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   beta, nbead

      use tass_variables, only : &
     &   rtass, stass, vtass, fictmass_tass, ntass, ikind_tass

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer :: m, n

      real(8) :: vsigma, gasdev

!-----------------------------------------------------------------------
!     /*   initial position of cv                                     */
!-----------------------------------------------------------------------

!     /*   loop of cv   */
      do n = 1, ntass

!        /*   cv: mean force dynamics   */

         if      ( ikind_tass(n) .eq. 1 ) then

!           /*   substitute instantaneous value   */

            do m = 1, nbead
               rtass(n,m) = stass(n,m)
            end do

!        /*   cv: constrained dynamics   */

         else if ( ikind_tass(n) .eq. 2 ) then

!           /*   intrapolated value   */

            if ( nbead .gt. 1 ) then

               do m = 1, nbead
                  rtass(n,m) = rtass(n,1) &
     &                       + ( rtass(n,nbead) - rtass(n,1) ) &
     &                       * dble(m-1) / dble(nbead-1)
               end do

            end if

!        /*   cv: metadynamics   */

         else if ( ikind_tass(n) .eq. 3 ) then

!           /*   substitute instantaneous value   */

            do m = 1, nbead
               rtass(n,m) = stass(n,m)
            end do

!        /*   cv   */
         end if

!     /*   loop of cv   */
      end do

!-----------------------------------------------------------------------
!     /*   initial velocity of cv                                     */
!-----------------------------------------------------------------------

      do m = 1, nbead
      do n = 1, ntass
         vsigma = sqrt(1.d0/beta/fictmass_tass(n))
         vtass(n,m) = vsigma*gasdev()
      end do
      end do

!-----------------------------------------------------------------------
!     /*   set boundary condition                                     */
!-----------------------------------------------------------------------

      call get_cv_tass

      return
      end





!***********************************************************************
      subroutine init_hills_tass
!***********************************************************************
!=======================================================================
!
!     initialize hills
!
!=======================================================================

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   nbead, iounit

      use tass_variables, only : &
     &   pot_lifted, gc_meta, gc_meta_save, rtass, &
     &   icv_start, ng_meta, ntass

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer :: m, n, ierr

!-----------------------------------------------------------------------
!     /*   default                                                    */
!-----------------------------------------------------------------------

      ierr = 0

!-----------------------------------------------------------------------
!     /*   initialize number of gaussians                             */
!-----------------------------------------------------------------------

      ng_meta = 0

!-----------------------------------------------------------------------
!     /*   initialize gaussian centers                                */
!-----------------------------------------------------------------------

      gc_meta(:,:) = 0.d0

!-----------------------------------------------------------------------
!     /*   history                                                    */
!-----------------------------------------------------------------------

      if      ( icv_start .eq. 0 ) then

!        //   initialize data   //

!        /*   potential lifted by gaussian   */
         pot_lifted = 0.d0

!        /*   last gaussian center   */

         do m = 1, nbead
         do n = 1, ntass
            gc_meta_save(n,m) = rtass(n,m)
         end do
         end do

      else if ( icv_start .eq. 1 ) then

!        //   read data to restart previous run   //

         open ( iounit, file = 'cv.ini', status = 'unknown' )

!           /*   read skip   */

            do m = 1, nbead
            do n = 1, ntass
               read ( iounit, *, iostat=ierr )
            end do
            end do

!           /*   potential lifted by gaussian   */

            read ( iounit, *, iostat=ierr ) pot_lifted

!           /*   last gaussian center   */

            do m = 1, nbead
            do n = 1, ntass
               read ( iounit, *, iostat=ierr ) gc_meta_save(n,m)
            end do
            end do

         close ( iounit )

         call error_handling( ierr, 'subroutine init_hills_tass', 26 )

      else if ( icv_start .eq. 2 ) then

         continue

      end if

      return
      end
