!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Nov 10, 2018 by M. Shiga
!      Description:     initialize metadynamics
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine init_position_cart_MPI
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   x, y, z, ux, uy, uz, hbar, beta, physmass, pi, beta, &
     &   beta_beadspread, natom, nbead, myrank

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer :: i, j

      real(8) :: usigma, gasdev

!-----------------------------------------------------------------------
!     /*   read centroid coordinates                                  */
!-----------------------------------------------------------------------

      call init_centroid_MPI

!-----------------------------------------------------------------------
!     /*   gaussian distribution by thermal de broglie wavelength     */
!-----------------------------------------------------------------------

!     /*   master process only   */
      if ( myrank .eq. 0 ) then

      if ( nbead .eq. 1 ) then

         do i = 1, natom
            x(i,1) = ux(i,1)
            y(i,1) = uy(i,1)
            z(i,1) = uz(i,1)
         end do

      else

         do j = 1, nbead
         do i = 1, natom
            usigma = sqrt(2.d0*pi*hbar*hbar*beta/physmass(i))/(8.d0*pi)
            usigma = usigma*sqrt( beta_beadspread/beta )
            x(i,j) = ux(i,1) + usigma*gasdev()
            y(i,j) = uy(i,1) + usigma*gasdev()
            z(i,j) = uz(i,1) + usigma*gasdev()
         end do
         end do

      end if

!     /*   master process only   */
      end if

!     /*   broadcast   */
      call my_mpi_bcast_real_2 ( x, natom, nbead )
      call my_mpi_bcast_real_2 ( y, natom, nbead )
      call my_mpi_bcast_real_2 ( z, natom, nbead )

!-----------------------------------------------------------------------
!     /*   x --> ux                                                   */
!-----------------------------------------------------------------------

      call nm_trans_cart( 3 )

      return
      end

