!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Nov 10, 2018 by M. Shiga
!      Description:     Gaussian distribution of beads
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine init_mode_MPI
!***********************************************************************
!=======================================================================
!
!     Gaussian distribution of quantum free atoms.
!
!=======================================================================

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   ux, uy, uz, beta, beta_beadspread, dnmmass, omega_p2, &
     &   natom, nbead, myrank

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer :: iatom, imode

      real(8) :: gasdev, usigma

!-----------------------------------------------------------------------
!     /*   start                                                      */
!-----------------------------------------------------------------------

      if ( myrank .eq. 0 ) then

         do imode = 2, nbead
         do iatom = 1, natom

!           /*   rms displacement at beta   */
            usigma = sqrt(1.d0/beta/omega_p2/dnmmass(iatom,imode))

!           /*   rms displacement at beta_beadspread    */
            usigma = usigma*sqrt(beta_beadspread/beta)

            ux(iatom,imode) = usigma*gasdev()
            uy(iatom,imode) = usigma*gasdev()
            uz(iatom,imode) = usigma*gasdev()

         end do
         end do

      end if

      call my_mpi_bcast_real_2 ( ux, natom, nbead )
      call my_mpi_bcast_real_2 ( uy, natom, nbead )
      call my_mpi_bcast_real_2 ( uz, natom, nbead )

      return
      end

