!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Nov 10, 2018 by M. Shiga
!      Description:     Gaussian distribution of beads
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine init_mode
!***********************************************************************
!=======================================================================
!
!     Gaussian distribution of quantum free atoms.
!
!=======================================================================

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   ux, uy, uz, beta, beta_beadspread, dnmmass, omega_p2, &
     &   natom, nbead

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer :: iatom, imode
      real(8) :: usigma, gasdev

!-----------------------------------------------------------------------
!     /*   start                                                      */
!-----------------------------------------------------------------------

      do imode = 2, nbead
      do iatom = 1, natom

!        /*   rms displacement at beta   */
         usigma = sqrt(1.d0/beta/omega_p2/dnmmass(iatom,imode))

!        /*   rms displacement at beta_beadspread    */
         usigma = usigma*sqrt(beta_beadspread/beta)

         ux(iatom,imode) = usigma*gasdev()
         uy(iatom,imode) = usigma*gasdev()
         uz(iatom,imode) = usigma*gasdev()

      end do
      end do

      return
      end

