!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Nov 10, 2018 by M. Shiga
!      Description:     initialize metadynamics
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine init_bath_meta
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   xbath, ybath, zbath, vxbath, vybath, vzbath, qmass, beta, &
     &   natom, nbead, nnhc, ncolor

      use meta_variables, only : &
     &   rbath_meta, qmass_meta, vbath_meta, nmeta

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer :: i, j, k, m

      real(8) :: vsigma, gasdev

!-----------------------------------------------------------------------
!     /*   thermostat attached to system                              */
!-----------------------------------------------------------------------

      do k = 1, nbead
      do j = 1, nnhc
      do i = 1, natom
         xbath(i,j,k) = 0.d0
         ybath(i,j,k) = 0.d0
         zbath(i,j,k) = 0.d0
      end do
      end do
      end do

      do k = 1, nbead
         vsigma = sqrt(1.d0/beta/qmass(k))
         do j = 1, nnhc
         do i = 1, natom
            vxbath(i,j,k) = vsigma*gasdev()
            vybath(i,j,k) = vsigma*gasdev()
            vzbath(i,j,k) = vsigma*gasdev()
         end do
         end do
      end do

!-----------------------------------------------------------------------
!     /*   thermostat attached to cv                                  */
!-----------------------------------------------------------------------

      rbath_meta(:,:,:,:) = 0.d0
      vbath_meta(:,:,:,:) = 0.d0

      do k = 1, nbead
      do m = 1, ncolor
      do j = 1, nnhc
      do i = 1, nmeta
         vsigma = sqrt(1.d0/beta/qmass_meta(m))
         vbath_meta(i,j,m,k) = vsigma*gasdev()
      end do
      end do
      end do
      end do

      return
      end





!***********************************************************************
      subroutine init_cv_meta
!***********************************************************************
!=======================================================================
!
!     initialize cv for metadynamics
!
!=======================================================================

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   beta, nbead

      use meta_variables, only : &
     &   rmeta, smeta, vmeta, fictmass_meta, nmeta

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer :: m, n

      real(8) :: vsigma, gasdev

!-----------------------------------------------------------------------
!     /*   initial position of cv                                     */
!-----------------------------------------------------------------------

      do m = 1, nbead
      do n = 1, nmeta
         rmeta(n,m) = smeta(n,m)
      end do
      end do

!-----------------------------------------------------------------------
!     /*   initial velocity of cv                                     */
!-----------------------------------------------------------------------

      do m = 1, nbead
      do n = 1, nmeta
         vsigma = sqrt(1.d0/beta/fictmass_meta(n))
         vmeta(n,m) = vsigma*gasdev()
      end do
      end do

      return
      end





!***********************************************************************
      subroutine init_hills_meta
!***********************************************************************
!=======================================================================
!
!     initialize hills
!
!=======================================================================

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   nbead, iounit

      use meta_variables, only : &
     &   pot_lifted, gc_meta, gc_meta_save, rmeta, &
     &   icv_start, ng_meta, nmeta

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer :: m, n, ierr

!-----------------------------------------------------------------------
!     /*   default                                                    */
!-----------------------------------------------------------------------

      ierr = 0

!-----------------------------------------------------------------------
!     /*   initialize number of gaussians                             */
!-----------------------------------------------------------------------

      ng_meta = 0

!-----------------------------------------------------------------------
!     /*   initialize gaussian centers                                */
!-----------------------------------------------------------------------

      gc_meta(:,:) = 0.d0

!-----------------------------------------------------------------------
!     /*   history                                                    */
!-----------------------------------------------------------------------

      if      ( icv_start .eq. 0 ) then

!        //   initialize data   //

!        /*   potential lifted by gaussian   */
         pot_lifted = 0.d0

!        /*   last gaussian center   */

         do m = 1, nbead
         do n = 1, nmeta
            gc_meta_save(n,m) = rmeta(n,m)
         end do
         end do

      else if ( icv_start .eq. 1 ) then

!        //   read data to restart previous run   //

         open ( iounit, file = 'cv.ini', status = 'unknown' )

!           /*   read skip   */

            do m = 1, nbead
            do n = 1, nmeta
               read ( iounit, *, iostat=ierr )
            end do
            end do

!           /*   potential lifted by gaussian   */

            read ( iounit, *, iostat=ierr ) pot_lifted

!           /*   last gaussian center   */

            do m = 1, nbead
            do n = 1, nmeta
               read ( iounit, *, iostat=ierr ) gc_meta_save(n,m)
            end do
            end do

         close ( iounit )

         call error_handling( ierr, 'subroutine init_hills_meta', 26 )

      else if ( icv_start .eq. 2 ) then

         continue

      end if

      return
      end
