!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Nov 10, 2018 by M. Shiga
!      Description:     polymers atomic masses
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine init_mass_polymers_atom_MPI
!***********************************************************************
!=======================================================================
!
!     set up masses for path integral MD
!
!=======================================================================

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   dnmmass, physmass, fictmass, gamma_p2, amu_mass_earth, &
     &   natom, nbead

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer :: i, j

!-----------------------------------------------------------------------
!     /*  fictitious masses of normal modes                           */
!-----------------------------------------------------------------------

!     /*   centroid   */

      do j = 1, natom
         fictmass(j,1) = physmass(j) * amu_mass_earth
      end do

!     /*   non-centroid   */

      do j = 1, natom
      do i = 2, nbead
         fictmass(j,i) = dnmmass(j,i) * gamma_p2
      end do
      end do

      return
      end





!***********************************************************************
      subroutine init_mass_polymers_cons_MPI
!***********************************************************************
!=======================================================================
!
!     set up masses for path integral MD
!
!=======================================================================

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   dnmmass, physmass, fictmass, gamma_p2, natom, nbead, iounit

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer :: i, j

!-----------------------------------------------------------------------
!     /*  fictitious masses of normal modes                           */
!-----------------------------------------------------------------------

!     /*   centroid   */

      do j = 1, natom
         fictmass(j,1) = physmass(j)
      end do

!     /*   non-centroid   */

      do j = 1, natom
      do i = 2, nbead
         fictmass(j,i) = dnmmass(j,i) * gamma_p2
      end do
      end do

      return
      end
