!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Nov 10, 2018 by M. Shiga
!      Description:     initialize and finalize external programs
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine init_extprograms
!***********************************************************************
!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : ipotential

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

!-----------------------------------------------------------------------
!     /*   initialize potential                                       */
!-----------------------------------------------------------------------

      if ( ipotential(1:4) .eq. 'PFP ' ) then

         call initialize_pfp

      end if

      return
      end





!***********************************************************************
      subroutine finalize_extprograms
!***********************************************************************
!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : ipotential

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

!-----------------------------------------------------------------------
!     /*   finalize potential                                         */
!-----------------------------------------------------------------------

      if ( ipotential(1:8) .eq. 'DFTBLIB ' ) then

         call finalize_libdftb

      else if ( ipotential(1:8) .eq. 'CP2KLIB ' ) then

         call finalize_libcp2k

      else if ( ipotential(1:4) .eq. 'PFP ' ) then

         call finalize_pfp

      end if

      return
      end

