!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Apr 24, 2022 by M. Shiga
!      Description:     initialize velocity of simulation box
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine init_box_position_rehmc
!***********************************************************************
!=======================================================================
!
!     initialize box positions
!
!=======================================================================

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   box, volume, boxinv, iounit, au_length, char_boundary, &
     &   box_bead, volume_bead, boxinv_bead, nbead

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

!     /*   initialize   */
      implicit none

!     /*   integers   */
      integer :: ierr, k

!     /*   real numbers   */
      real(8) :: det3

!     /*   unit conversion factor   */
      real(8) :: bohr2ang = au_length * 1.d+10

!-----------------------------------------------------------------------
!     /*   box and volume                                             */
!-----------------------------------------------------------------------

!     /*   open file   */
      open ( iounit, file = 'input.dat' )

!     /*   tag   */
      call search_tag ( '<iboundary>', 11, iounit, ierr )

!     /*   skip a line   */
      read ( iounit, iostat=ierr )

!     /*   box size   */
      read ( iounit, iostat=ierr ) box(1,1), box(1,2), box(1,3)
      read ( iounit, iostat=ierr ) box(2,1), box(2,2), box(2,3)
      read ( iounit, iostat=ierr ) box(3,1), box(3,2), box(3,3)

!     /*   close file   */
      close( iounit )

!     /*   unit conversion   */
      if ( ierr .eq. 0 ) then
      if ( char_boundary(1:9) .eq. 'ANGSTROM ' ) then
         box(:,:) = box(:,:) / bohr2ang
      end if
      end if

!     /*   reference volume   */
      volume = det3( box )

!     /*   inverse matrix of cell matrix   */
      call inv3 ( box, boxinv )

!     /*   copy for all beads   */
      do k = 1, nbead
         box_bead(:,:,k) = box(:,:)
         boxinv_bead(:,:,k) = boxinv(:,:)
         volume_bead(k) = volume
      end do

      return
      end





!***********************************************************************
      subroutine init_box_velocity_rehmc
!***********************************************************************
!=======================================================================
!
!     initialize box velocities
!
!=======================================================================

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   box_bead, vbox_bead, vlog_bead, vvol_bead, volmass, beta, vvol, &
     &  vlog, vbox, boxmass, boxdot, boxdot_bead, iounit, nbead

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

!     /*   initialize   */
      implicit none

!     /*   integers   */
      integer :: i, j, k, l

!     /*   real numbers   */
      real(8) :: gasdev, vsigma

!-----------------------------------------------------------------------
!     /*  box velocities                                              */
!-----------------------------------------------------------------------

!     /*   loop of beads   */
      do k = 1, nbead

!        /*   gaussian dispersion   */
         vsigma = sqrt( 1.d0 / beta / volmass )

!        /*   gaussian distribution   */
         vvol = vsigma * gasdev()

!        /*   copy value   */
         vvol_bead(k) = vvol

!     /*   loop of beads   */
      end do

!-----------------------------------------------------------------------
!     /*  box velocities                                              */
!-----------------------------------------------------------------------

!     /*   loop of beads   */
      do k = 1, nbead

!        /*   gaussian dispersion   */
         vsigma = sqrt( 1.d0 / beta / boxmass(1,1) )

!        /*   gaussian distribution   */
         vlog = vsigma * gasdev()

!        /*   copy value   */
         vlog_bead(k) = vlog

!     /*   loop of beads   */
      end do

!-----------------------------------------------------------------------
!     /*  box velocities                                              */
!-----------------------------------------------------------------------

!     /*   loop of beads   */
      do k = 1, nbead

!        /*  box velocities: diagonal term   */

!        /*   loop of xyz   */
         do i = 1, 3

!           /*   gaussian dispersion   */
            vsigma = sqrt(1.d0/beta/boxmass(i,i))

!           /*   gaussian distribution   */
            vbox(i,i) = vsigma * gasdev()

!        /*   loop of xyz   */
         end do

!        /*  box velocities: non-diagonal term, rotation removed   */

!        /*   loop of xyz   */
         do i = 1, 3-1
         do j = i+1, 3

!           /*   this is incorrect;  box rotation not considered   */
!           vsigma = sqrt( 1.d0 / beta / boxmass(i,j) )

!           /*   this is correct   */
            vsigma = sqrt( 1.d0 / beta / boxmass(i,j) / 2.d0 )

!           /*   gaussian distribution   */
            vbox(i,j) = vsigma * gasdev()

!           /*   copy value   */
            vbox(j,i) = vbox(i,j)

!        /*   loop of xyz   */
         end do
         end do

!        /*   copy value   */
         vbox_bead(:,:,k) = vbox(:,:)

!     /*   loop of beads   */
      end do

!-----------------------------------------------------------------------
!     /*   box velocity                                               */
!-----------------------------------------------------------------------

      do l = 1, nbead

         boxdot(:,:) = 0.d0

         do k = 1, 3
         do j = 1, 3
         do i = 1, 3

            boxdot(i,j) = boxdot(i,j) &
     &         + vbox_bead(i,k,l) * box_bead(k,j,l)

         end do
         end do
         end do

         boxdot_bead(:,:,l) = boxdot(:,:)

      end do

      return
      end
