!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Nov 10, 2018 by M. Shiga
!      Description:     initialize velocity of simulation box
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine init_box_position_MPI
!***********************************************************************
!=======================================================================
!
!     initialize box velocities
!
!=======================================================================

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   box, volume, boxinv, iounit, au_length, char_boundary, myrank

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer :: ierr

      real(8) :: det3

      real(8) :: bohr2ang = au_length * 1.d+10

!-----------------------------------------------------------------------
!     /*   box and volume                                             */
!-----------------------------------------------------------------------

      if ( myrank .eq. 0 ) then

         open (iounit,file = 'input.dat')

!           /*   tag   */
            call search_tag ( '<iboundary>', 11, iounit, ierr )

!           /*   skip a line   */
            read(iounit,*)

!           /*   box size   */
            read(iounit,*) box(1,1), box(1,2), box(1,3)
            read(iounit,*) box(2,1), box(2,2), box(2,3)
            read(iounit,*) box(3,1), box(3,2), box(3,3)

         close(iounit)

!        /*   unit conversion   */
         if ( ierr .eq. 0 ) then
         if ( char_boundary(1:9) .eq. 'ANGSTROM ' ) then
            box(:,:) = box(:,:) / bohr2ang
         end if
         end if

      end if

!     /*   communication   */
      call my_mpi_bcast_real_2 ( box, 3, 3 )

!     /*   reference volume   */
      volume = det3( box )

!     /*   inverse matrix of cell matrix   */
      call inv3 ( box, boxinv )

      return
      end





!***********************************************************************
      subroutine init_box_velocity_MPI
!***********************************************************************
!=======================================================================
!
!     initialize box velocities
!
!=======================================================================

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   volmass, beta, vvol, vlog, vbox, boxmass, myrank

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer :: i, j

      real(8) :: gasdev, vsigma

!-----------------------------------------------------------------------
!     /*  box velocities                                              */
!-----------------------------------------------------------------------

      if ( myrank .eq. 0 ) then

         vsigma = sqrt(1.d0/beta/volmass)

         vvol = vsigma*gasdev()

      end if

!-----------------------------------------------------------------------
!     /*  box velocities                                              */
!-----------------------------------------------------------------------

      if ( myrank .eq. 0 ) then

         vsigma = sqrt(1.d0/beta/boxmass(1,1))

         vlog = vsigma*gasdev()

      end if

!-----------------------------------------------------------------------
!     /*  box velocities                                              */
!-----------------------------------------------------------------------

      if ( myrank .eq. 0 ) then

!        /*  box velocities: diagonal term   */

         do i = 1, 3

            vsigma = sqrt(1.d0/beta/boxmass(i,i))

            vbox(i,i) = vsigma*gasdev()

         end do

!        /*  box velocities: non-diagonal term, rotation removed   */

         do i = 1, 3-1
         do j = i+1, 3

!           /*   this is incorrect;  box rotation not considered   */
!           vsigma = sqrt(1.d0/beta/boxmass(i,j))

!           /*   this is correct   */
            vsigma = sqrt(1.d0/beta/boxmass(i,j)/2.d0)

            vbox(i,j) = vsigma*gasdev()

            vbox(j,i) = vbox(i,j)

         end do
         end do

      end if

!-----------------------------------------------------------------------
!     /*  communication                                               */
!-----------------------------------------------------------------------

      call my_mpi_bcast_real_0 ( vvol )

      call my_mpi_bcast_real_0 ( vlog )

      call my_mpi_bcast_real_2 ( vbox, 3, 3 )

      return
      end
