!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Nov 10, 2018 by M. Shiga
!      Description:     initialize velocity of simulation box
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine init_box_position
!***********************************************************************
!=======================================================================
!
!     initialize box velocities
!
!=======================================================================

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   box, volume, boxinv, iounit, au_length, char_boundary

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer :: ierr

      real(8) :: det3

      real(8) :: bohr2ang = au_length * 1.d+10

!-----------------------------------------------------------------------
!     /*   box and volume                                             */
!-----------------------------------------------------------------------

      open (iounit,file = 'input.dat')

!        /*   tag   */
         call search_tag ( '<iboundary>', 11, iounit, ierr )

!        /*   skip a line   */
         read(iounit,*)

!        /*   box size   */
         read(iounit,*) box(1,1), box(1,2), box(1,3)
         read(iounit,*) box(2,1), box(2,2), box(2,3)
         read(iounit,*) box(3,1), box(3,2), box(3,3)

      close(iounit)

!     /*   unit conversion   */
      if ( ierr .eq. 0 ) then
      if ( char_boundary(1:9) .eq. 'ANGSTROM ' ) then
         box(:,:) = box(:,:) / bohr2ang
      end if
      end if

!     /*   reference volume   */
      volume = det3( box )

!     /*   inverse matrix of cell matrix   */
      call inv3 ( box, boxinv )

      return
      end





!***********************************************************************
      subroutine init_box_velocity
!***********************************************************************
!=======================================================================
!
!     initialize box velocities
!
!=======================================================================

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   volmass, beta, vvol, vlog, vbox, boxmass

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer :: i, j

      real(8) :: gasdev, vsigma

!-----------------------------------------------------------------------
!     /*  box velocities                                              */
!-----------------------------------------------------------------------

      vsigma = sqrt(1.d0/beta/volmass)

      vvol = vsigma*gasdev()

!-----------------------------------------------------------------------
!     /*  box velocities                                              */
!-----------------------------------------------------------------------

      vsigma = sqrt(1.d0/beta/boxmass(1,1))

      vlog = vsigma*gasdev()

!-----------------------------------------------------------------------
!     /*  box velocities: diagonal term                               */
!-----------------------------------------------------------------------

      do i = 1, 3

         vsigma = sqrt(1.d0/beta/boxmass(i,i))

         vbox(i,i) = vsigma*gasdev()

      end do

!-----------------------------------------------------------------------
!     /*  box velocities: non-diagonal term, rotation removed         */
!-----------------------------------------------------------------------

      do i = 1, 3-1
      do j = i+1, 3

!        /*   this is incorrect;  box rotation not considered   */
!        vsigma = sqrt(1.d0/beta/boxmass(i,j))

!        /*   this is correct   */
         vsigma = sqrt(1.d0/beta/boxmass(i,j)/2.d0)

         vbox(i,j) = vsigma*gasdev()

         vbox(j,i) = vbox(i,j)

      end do
      end do

      return
      end

