!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Nov 10, 2018 by M. Shiga
!      Description:     thermostat setup for multiscale systems
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine init_bath_multi_me_MPI
!***********************************************************************
!=======================================================================
!
!     initialize thermostat coordinates and thermostat velocities
!
!=======================================================================

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   xbath_cent, ybath_cent, zbath_cent,xbath, ybath, zbath, &
     &   vxbath_cent, vybath_cent, vzbath_cent, vxbath, vybath, vzbath, &
     &   beta, ncolor, nnhc, nbead, natom, myrank

      use qmmm_variables, only : &
     &   qmass_cent_multi_a, qmass_cent_multi_b, qmass_multi_a, &
     &   qmass_multi_b, layer

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer :: i, iatom, imode, inhc, j, m

      real(8) :: gasdev, vsigma

!-----------------------------------------------------------------------
      if ( myrank .eq. 0 ) then
!-----------------------------------------------------------------------

!-----------------------------------------------------------------------
!     /*  centroid coordinates                                        */
!-----------------------------------------------------------------------

      do i = 1, nnhc
      do j = 1, natom
      do m = 1, ncolor
         xbath_cent(j,i,m) = 0.d0
         ybath_cent(j,i,m) = 0.d0
         zbath_cent(j,i,m) = 0.d0
      end do
      end do
      end do

!-----------------------------------------------------------------------
!     /*  centroid velocities                                         */
!-----------------------------------------------------------------------

      do i = 1, nnhc
      do j = 1, natom
         if ( layer(j)(1:1) .eq. 'A' ) then
            do m = 1, ncolor
               vsigma = sqrt(1.d0/beta/qmass_cent_multi_a(i,m))
               vxbath_cent(j,i,m) = vsigma*gasdev()
               vybath_cent(j,i,m) = vsigma*gasdev()
               vzbath_cent(j,i,m) = vsigma*gasdev()
            end do
         end if
      end do
      end do

      do i = 1, nnhc
      do j = 1, natom
         if ( layer(j)(1:1) .eq. 'B' ) then
            do m = 1, ncolor
               vsigma = sqrt(1.d0/beta/qmass_cent_multi_b(i,m))
               vxbath_cent(j,i,m) = vsigma*gasdev()
               vybath_cent(j,i,m) = vsigma*gasdev()
               vzbath_cent(j,i,m) = vsigma*gasdev()
            end do
         end if
      end do
      end do

!-----------------------------------------------------------------------
!     /*  non-centroid coordinates                                    */
!-----------------------------------------------------------------------

      do imode = 1, nbead
      do inhc  = 1, nnhc
      do iatom = 1, natom
         xbath(iatom,inhc,imode) = 0.d0
         ybath(iatom,inhc,imode) = 0.d0
         zbath(iatom,inhc,imode) = 0.d0
      end do
      end do
      end do

!-----------------------------------------------------------------------
!     /*  non-centroid velocities                                     */
!-----------------------------------------------------------------------

      do imode = 1, nbead
      do inhc  = 1, nnhc
      do iatom = 1, natom
         if ( layer(iatom)(1:1) .eq. 'A' ) then
            vsigma = sqrt(1.d0/beta/qmass_multi_a(imode))
            vxbath(iatom,inhc,imode) = vsigma*gasdev()
            vybath(iatom,inhc,imode) = vsigma*gasdev()
            vzbath(iatom,inhc,imode) = vsigma*gasdev()
         end if
      end do
      end do
      end do

      do imode = 1, nbead
      do inhc  = 1, nnhc
      do iatom = 1, natom
         if ( layer(iatom)(1:1) .eq. 'B' ) then
            vsigma = sqrt(1.d0/beta/qmass_multi_b(imode))
            vxbath(iatom,inhc,imode) = vsigma*gasdev()
            vybath(iatom,inhc,imode) = vsigma*gasdev()
            vzbath(iatom,inhc,imode) = vsigma*gasdev()
         end if
      end do
      end do
      end do

!-----------------------------------------------------------------------
      end if
!-----------------------------------------------------------------------

      call my_mpi_bcast_real_3 (   xbath_cent, natom, nnhc, ncolor  )
      call my_mpi_bcast_real_3 (   ybath_cent, natom, nnhc, ncolor  )
      call my_mpi_bcast_real_3 (   zbath_cent, natom, nnhc, ncolor  )

      call my_mpi_bcast_real_3 (  vxbath_cent, natom, nnhc, ncolor  )
      call my_mpi_bcast_real_3 (  vybath_cent, natom, nnhc, ncolor  )
      call my_mpi_bcast_real_3 (  vzbath_cent, natom, nnhc, ncolor  )

      call my_mpi_bcast_real_3 (  xbath, natom, nnhc, nbead )
      call my_mpi_bcast_real_3 (  ybath, natom, nnhc, nbead )
      call my_mpi_bcast_real_3 (  zbath, natom, nnhc, nbead )

      call my_mpi_bcast_real_3 ( vxbath, natom, nnhc, nbead )
      call my_mpi_bcast_real_3 ( vybath, natom, nnhc, nbead )
      call my_mpi_bcast_real_3 ( vzbath, natom, nnhc, nbead )

      return
      end

