!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Nov 10, 2018 by M. Shiga
!      Description:     initialize themostats
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine init_bath_cart_MPI
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   xbath, ybath, zbath, vxbath, vybath, vzbath, qmass, beta, &
     &   natom, nbead, nnhc, myrank

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer :: i, j, k

      real(8) :: vsigma, gasdev

!-----------------------------------------------------------------------
!     /*   master process only                                        */
!-----------------------------------------------------------------------

      if ( myrank .eq. 0 ) then

!-----------------------------------------------------------------------
!     /*   thermostat attached to system                              */
!-----------------------------------------------------------------------

      do k = 1, nbead
      do j = 1, nnhc
      do i = 1, natom
         xbath(i,j,k) = 0.d0
         ybath(i,j,k) = 0.d0
         zbath(i,j,k) = 0.d0
      end do
      end do
      end do

      do k = 1, nbead
         vsigma = sqrt(1.d0/beta/qmass(k))
         do j = 1, nnhc
         do i = 1, natom
            vxbath(i,j,k) = vsigma*gasdev()
            vybath(i,j,k) = vsigma*gasdev()
            vzbath(i,j,k) = vsigma*gasdev()
         end do
         end do
      end do

!-----------------------------------------------------------------------
!     /*   master process only                                        */
!-----------------------------------------------------------------------

      end if

!-----------------------------------------------------------------------
!     /*   broadcast                                                  */
!-----------------------------------------------------------------------

      call my_mpi_bcast_real_3( xbath, natom, nnhc, nbead )
      call my_mpi_bcast_real_3( ybath, natom, nnhc, nbead )
      call my_mpi_bcast_real_3( zbath, natom, nnhc, nbead )

      call my_mpi_bcast_real_3( vxbath, natom, nnhc, nbead )
      call my_mpi_bcast_real_3( vybath, natom, nnhc, nbead )
      call my_mpi_bcast_real_3( vzbath, natom, nnhc, nbead )

      return
      end





!***********************************************************************
      subroutine init_bath_cart_revised_MPI
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   beta, qmass_cart, xbath_cart, ybath_cart, zbath_cart, &
     &   vxbath_cart, vybath_cart, vzbath_cart, natom, nbead, nnhc, &
     &   ncolor, myrank

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer :: i, j, k, m

      real(8) :: vsigma, gasdev

!-----------------------------------------------------------------------
!     /*   master process only                                        */
!-----------------------------------------------------------------------

      if ( myrank .eq. 0 ) then

!-----------------------------------------------------------------------
!     /*  coordinates                                                 */
!-----------------------------------------------------------------------

      do k = 1, nbead
      do m = 1, ncolor
      do i = 1, nnhc
      do j = 1, natom
         xbath_cart(j,i,m,k) = 0.d0
         ybath_cart(j,i,m,k) = 0.d0
         zbath_cart(j,i,m,k) = 0.d0
      end do
      end do
      end do
      end do

!-----------------------------------------------------------------------
!     /*  velocities                                                  */
!-----------------------------------------------------------------------

      do k = 1, nbead
      do m = 1, ncolor
      do i = 1, nnhc
      do j = 1, natom
         vsigma = sqrt(1.d0/beta/qmass_cart(i,m))
         vxbath_cart(j,i,m,k) = vsigma*gasdev()
         vybath_cart(j,i,m,k) = vsigma*gasdev()
         vzbath_cart(j,i,m,k) = vsigma*gasdev()
      end do
      end do
      end do
      end do

!-----------------------------------------------------------------------
!     /*   master process only                                        */
!-----------------------------------------------------------------------

      end if

!-----------------------------------------------------------------------
!     /*   broadcast                                                  */
!-----------------------------------------------------------------------

      call my_mpi_bcast_real_4( xbath_cart, natom, nnhc, ncolor, nbead )
      call my_mpi_bcast_real_4( ybath_cart, natom, nnhc, ncolor, nbead )
      call my_mpi_bcast_real_4( zbath_cart, natom, nnhc, ncolor, nbead )

      call my_mpi_bcast_real_4( vxbath_cart, natom, nnhc, ncolor, nbead)
      call my_mpi_bcast_real_4( vybath_cart, natom, nnhc, ncolor, nbead)
      call my_mpi_bcast_real_4( vzbath_cart, natom, nnhc, ncolor, nbead)

      return
      end

