!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Nov 10, 2018 by M. Shiga
!      Description:     initialize themostats
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine init_bath_cart
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   xbath, ybath, zbath, vxbath, vybath, vzbath, qmass, beta, &
     &   natom, nbead, nnhc

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer :: i, j, k

      real(8) :: vsigma, gasdev

!-----------------------------------------------------------------------
!     /*   thermostat attached to system                              */
!-----------------------------------------------------------------------

      do k = 1, nbead
      do j = 1, nnhc
      do i = 1, natom
         xbath(i,j,k) = 0.d0
         ybath(i,j,k) = 0.d0
         zbath(i,j,k) = 0.d0
      end do
      end do
      end do

      do k = 1, nbead
         vsigma = sqrt(1.d0/beta/qmass(k))
         do j = 1, nnhc
         do i = 1, natom
            vxbath(i,j,k) = vsigma*gasdev()
            vybath(i,j,k) = vsigma*gasdev()
            vzbath(i,j,k) = vsigma*gasdev()
         end do
         end do
      end do

      return
      end





!***********************************************************************
      subroutine init_bath_cart_revised
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   beta, qmass_cart, xbath_cart, ybath_cart, zbath_cart, &
     &   vxbath_cart, vybath_cart, vzbath_cart, natom, nbead, nnhc, &
     &   ncolor

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer :: i, j, k, m

      real(8) :: vsigma, gasdev

!-----------------------------------------------------------------------
!     /*  coordinates                                                 */
!-----------------------------------------------------------------------

      do k = 1, nbead
      do m = 1, ncolor
      do i = 1, nnhc
      do j = 1, natom
         xbath_cart(j,i,m,k) = 0.d0
         ybath_cart(j,i,m,k) = 0.d0
         zbath_cart(j,i,m,k) = 0.d0
      end do
      end do
      end do
      end do

!-----------------------------------------------------------------------
!     /*  velocities                                                  */
!-----------------------------------------------------------------------

      do k = 1, nbead
      do m = 1, ncolor
      do i = 1, nnhc
      do j = 1, natom
         vsigma = sqrt(1.d0/beta/qmass_cart(i,m))
         vxbath_cart(j,i,m,k) = vsigma*gasdev()
         vybath_cart(j,i,m,k) = vsigma*gasdev()
         vzbath_cart(j,i,m,k) = vsigma*gasdev()
      end do
      end do
      end do
      end do

      return
      end

