!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Nov 10, 2018 by M. Shiga
!      Description:     Gram-Schmidt orthogonalization
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine gram_schmidt ( a, n, m )
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer :: i, j, k, n, m

      real(8) :: bij, suma

      real(8), dimension(n,m):: a

!-----------------------------------------------------------------------
!     /*   normalize a                                                */
!-----------------------------------------------------------------------

      do i = 1, m

         suma = 0.d0

         do k = 1, n
            suma = suma + a(k,i)*a(k,i)
         end do

         suma = 1.d0/sqrt(suma)

         do k = 1, n
            a(k,i) = a(k,i)*suma
         end do

      end do

!-----------------------------------------------------------------------
!     /*   main loop                                                  */
!-----------------------------------------------------------------------

      do j = 1, m

         do i = 1, j-1

!           /*   calculate inner product of vectors i and j   */

            bij = 0.d0

            do k = 1, n
               bij = bij + a(k,i)*a(k,j)
            end do

!           /*   project out the component of vector i   */

            do k = 1, n
               a(k,j) = a(k,j) - bij*a(k,i)
            end do

         end do

!        /*   normalize a   */

         suma = 0.d0

         do k = 1, n
            suma = suma + a(k,j)*a(k,j)
         end do

         suma = 1.d0/sqrt(suma)

         do k = 1, n
            a(k,j) = a(k,j)*suma
         end do

      end do

      return
      end
