!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Nov 10, 2018 by M. Shiga
!      Description:     switching function
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine getswf ( r, rin, rout, swf, dswf )
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      real(8) :: c0, c1, c2, c3, dr, dr3, r, rin, rout, rout2, swf, dswf

!-----------------------------------------------------------------------
!     /*   switching function                                         */
!-----------------------------------------------------------------------

      if ( r .le. rin ) then

         swf  = 1.d0
         dswf = 0.d0

      else if ( r .ge. rout ) then

         swf  = 0.d0
         dswf = 0.d0

      else

         dr = rout - rin

         rout2 = rout*rout

         dr3   = dr*dr*dr

         c0 = + rout*rout2 - 3.d0*rin*rout2
         c1 = + 6.d0*rin*rout
         c2 = - 3.d0*rin - 3.d0*rout
         c3 = + 2.d0

         c0 = c0 /dr3
         c1 = c1 /dr3
         c2 = c2 /dr3
         c3 = c3 /dr3

!        /*   switching function   */
         swf  = c3*r*r*r + c2*r*r + c1*r + c0

!        /*   gradient of switching function   */
         dswf = 3.d0*c3*r*r + 2.d0*c2*r + c1

      end if

      return
      end

