!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga, H. Kimizuka
!      Last updated:    Jan 8, 2019 by M. Shiga
!      Description:     spline intrapolation of string
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      pure function getspline_grad_eam( xa, ya, y2a, n, x ) result(dy)
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer,intent(in) :: n
      integer :: klo, khi, k

      real(8),intent(in) :: x
      real(8) :: h, a, b, dy, hinv, xhi, xlo

      real(8),intent(in) :: xa(n), ya(n), y2a(n)

!-----------------------------------------------------------------------
!     /*   regular grid                                               */
!-----------------------------------------------------------------------

      klo = int( ( x-xa(1) ) / ( xa(n)-xa(1) ) * dble(n-1) ) + 1
      khi = klo + 1

      xhi = xa(khi)
      xlo = xa(klo)

!-----------------------------------------------------------------------
!     /*   irregular grid                                             */
!-----------------------------------------------------------------------

      if ( ( x .gt. xhi ) .or. ( x .lt. xlo ) ) then

         klo = 1
         khi = n

         do while ( khi-klo .gt. 1 )

            k = ( khi + klo ) / 2
            if ( xa(k) .gt. x ) then
               khi = k
            else
               klo = k
            end if

         end do

         xhi = xa(khi)
         xlo = xa(klo)

      end if

!-----------------------------------------------------------------------
!     /*   spline fit                                                 */
!-----------------------------------------------------------------------

      h = xhi - xlo

      hinv = 1.d0 / h

      a = ( xhi - x ) * hinv
      b = 1.d0 - a

      dy = ( - ya(klo) + ya(khi) ) * hinv &
     &   + ( - ( 3.d0*a*a - 1.d0 ) * y2a(klo) &
     &       + ( 3.d0*b*b - 1.d0 ) * y2a(khi) ) * h / 6.d0

      return
      end function getspline_grad_eam

