!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Nov 10, 2018 by M. Shiga
!      Description:     hessian calculation
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine gethess_MPI
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      implicit none

!-----------------------------------------------------------------------
!     /*   start                                                      */
!-----------------------------------------------------------------------

      call gethess_fdiff_MPI

!-----------------------------------------------------------------------
!     /*   write hessian                                              */
!-----------------------------------------------------------------------

      call restart_hess_MPI( 2 )


      return
      end





!***********************************************************************
      subroutine restart_hess_MPI( ioption )
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : hessian, nbead, natom, iounit, myrank

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      implicit none

      integer :: i, j, k, idummy, ioption

!-----------------------------------------------------------------------
!     /*   read                                                       */
!-----------------------------------------------------------------------

      if ( ioption .eq. 1 ) then

         if ( myrank .eq. 0 ) then

            open ( iounit, file = 'hessian.out' )

            do k = 1, nbead
            do i = 1, 3*natom
            do j = 1, 3*natom
               read( iounit, * ) idummy, idummy, hessian(i,j,k)
            end do
            end do
            end do

            close( iounit )

         end if

!        /*   mpi communication   */
         call my_mpi_bcast_real_3 ( hessian, 3*natom, 3*natom, nbead )

      end if

!-----------------------------------------------------------------------
!     /*   write                                                      */
!-----------------------------------------------------------------------

      if ( ioption .eq. 2 ) then

         if ( myrank .eq. 0 ) then

         open ( iounit, file = 'hessian.out' )

            do k = 1, nbead
            do i = 1, 3*natom
            do j = 1, 3*natom
               write( iounit, '(2i6,e24.16)' ) i, j, hessian(i,j,k)
            end do
            end do
            end do

         close( iounit )

         end if

      end if

      return
      end





!***********************************************************************
      subroutine gethess_fdiff_MPI
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   x, y, z, fx, fy, fz, fxp, fyp, fzp, fxm, fym, fzm, &
     &   fdiff, hessian, natom, nbead, iounit, atom_change, myrank

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer :: i, j, k, l, m

      integer, save :: iset = 0

!-----------------------------------------------------------------------
!     /*   memory allocation                                          */
!-----------------------------------------------------------------------

      if ( iset .eq. 0 ) then

!        /*   finite difference parameter   */
         call read_real1_MPI ( fdiff, '<fdiff>', 7, iounit )

!        /*   memory allocation:  forces   */

         if ( .not. allocated( fxp ) ) &
     &      allocate( fxp(natom,nbead) )
         if ( .not. allocated( fyp ) ) &
     &      allocate( fyp(natom,nbead) )
         if ( .not. allocated( fzp ) ) &
     &      allocate( fzp(natom,nbead) )
         if ( .not. allocated( fxm ) ) &
     &      allocate( fxm(natom,nbead) )
         if ( .not. allocated( fym ) ) &
     &      allocate( fym(natom,nbead) )
         if ( .not. allocated( fzm ) ) &
     &      allocate( fzm(natom,nbead) )

!        /*   memory allocation:  hessian   */
         if ( .not. allocated( hessian ) ) &
     &      allocate( hessian(3*natom,3*natom,nbead) )

         iset = 1

      end if

!-----------------------------------------------------------------------
!     /*   make hessian matrix                                        */
!-----------------------------------------------------------------------

      if ( myrank .eq. 0 ) then
         write( 6, '(a)' ) 'Hessian calculation for each atom.'
         write( 6, '(a)' ) 
      end if

      hessian(:,:,:) = 0.d0

      do i = 1, natom

!        //   skip frozen atoms
         if ( atom_change(i)(1:7) .eq. 'FREEZE ' ) cycle

         x(i,:) = x(i,:) - fdiff

         call getforce_MPI

         fxm(:,:) = fx(:,:)
         fym(:,:) = fy(:,:)
         fzm(:,:) = fz(:,:)

         x(i,:) = x(i,:) + 2.d0*fdiff

         call getforce_MPI

         fxp(:,:) = fx(:,:)
         fyp(:,:) = fy(:,:)
         fzp(:,:) = fz(:,:)

         x(i,:) = x(i,:) - fdiff

         do m = 1, nbead
         do j = 1, natom
            k = 3*(i-1) + 1
            l = 3*(j-1) + 1
            hessian(k,l,m)  =  - ( fxp(j,m) - fxm(j,m) ) /(2.d0*fdiff)
            k = 3*(i-1) + 1
            l = 3*(j-1) + 2
            hessian(k,l,m)  =  - ( fyp(j,m) - fym(j,m) ) /(2.d0*fdiff)
            k = 3*(i-1) + 1
            l = 3*(j-1) + 3
            hessian(k,l,m)  =  - ( fzp(j,m) - fzm(j,m) ) /(2.d0*fdiff)
         end do
         end do

         y(i,:) = y(i,:) - fdiff

         call getforce_MPI

         fxm(:,:) = fx(:,:)
         fym(:,:) = fy(:,:)
         fzm(:,:) = fz(:,:)

         y(i,:) = y(i,:) + 2.d0*fdiff

         call getforce_MPI

         fxp(:,:) = fx(:,:)
         fyp(:,:) = fy(:,:)
         fzp(:,:) = fz(:,:)

         y(i,:) = y(i,:) - fdiff

         do m = 1, nbead
         do j = 1, natom
            k = 3*(i-1) + 2
            l = 3*(j-1) + 1
            hessian(k,l,m)  =  - ( fxp(j,m) - fxm(j,m) ) /(2.d0*fdiff)
            k = 3*(i-1) + 2
            l = 3*(j-1) + 2
            hessian(k,l,m)  =  - ( fyp(j,m) - fym(j,m) ) /(2.d0*fdiff)
            k = 3*(i-1) + 2
            l = 3*(j-1) + 3
            hessian(k,l,m)  =  - ( fzp(j,m) - fzm(j,m) ) /(2.d0*fdiff)
         end do
         end do

         z(i,:) = z(i,:) - fdiff

         call getforce_MPI

         fxm(:,:) = fx(:,:)
         fym(:,:) = fy(:,:)
         fzm(:,:) = fz(:,:)

         z(i,:) = z(i,:) + 2.d0*fdiff

         call getforce_MPI

         fxp(:,:) = fx(:,:)
         fyp(:,:) = fy(:,:)
         fzp(:,:) = fz(:,:)

         z(i,:) = z(i,:) - fdiff

         do m = 1, nbead
         do j = 1, natom
            k = 3*(i-1) + 3
            l = 3*(j-1) + 1
            hessian(k,l,m)  =  - ( fxp(j,m) - fxm(j,m) ) /(2.d0*fdiff)
            k = 3*(i-1) + 3
            l = 3*(j-1) + 2
            hessian(k,l,m)  =  - ( fyp(j,m) - fym(j,m) ) /(2.d0*fdiff)
            k = 3*(i-1) + 3
            l = 3*(j-1) + 3
            hessian(k,l,m)  =  - ( fzp(j,m) - fzm(j,m) ) /(2.d0*fdiff)
         end do
         end do

         if ( myrank .eq. 0 ) then
            if ( mod(i,12) .eq. 0 ) then
               write( 6, '(i6)', advance='yes' ) i
            else
               write( 6, '(i6)', advance='no' ) i
            end if
         end if

      end do

      if ( myrank .eq. 0 ) then
         write( 6, '(a)' )
         if ( mod(natom,12) .ne. 0 ) then
            write( 6, '(a)' )
         end if
         write( 6, '(a)' ) 'Hessian calculation done.'
         write( 6, '(a)' )
      end if

      return
      end

