!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Nov 10, 2018 by M. Shiga
!      Description:     forces in Tully fewest switches
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine getforce_tfs_MPI
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   fx, fy, fz, pot, potential, nbead, ipotential, natom

      use multistate_variables, only : &
     &   vstate, gxstate, gystate, gzstate, dxstate, dystate, dzstate, &
     &   dipxstate, dipystate, dipzstate, istate_tfs

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer :: k, l

!-----------------------------------------------------------------------
!     /*   start                                                      */
!-----------------------------------------------------------------------

!     /*   potential   */
      vstate(:,:,:) = 0.d0

!     /*   forces   */
      gxstate(:,:,:,:) = 0.d0
      gystate(:,:,:,:) = 0.d0
      gzstate(:,:,:,:) = 0.d0

!     /*   forces   */
      dxstate(:,:,:,:) = 0.d0
      dystate(:,:,:,:) = 0.d0
      dzstate(:,:,:,:) = 0.d0

!     /*   dipole moment   */
      dipxstate(:,:)   = 0.d0
      dipystate(:,:)   = 0.d0
      dipzstate(:,:)   = 0.d0

!-----------------------------------------------------------------------
!     /*   calculate nonadiabatic potential                           */
!     /*      input  = x, y, z                                        */
!     /*      output = vstate, gxstate, gystate, gzstate,             */
!     /*               dxstate, dystate, dzstate                      */
!-----------------------------------------------------------------------

!     ===  molpro  ===

      if      ( ipotential(1:7) .eq. 'MOLPRO ' ) then

         call force_molpro_MPI

!     ===  tully's model  ===

      else if ( ipotential(1:6) .eq. 'TULLY ' ) then

         call force_tully_MPI

!     ===  error  ===

      else

         call error_handling_MPI( 1, 'subroutine getforce_tfs_MPI', 27 )

      end if

!-----------------------------------------------------------------------
!     /*   potential                                                  */
!-----------------------------------------------------------------------

      do l = 1, nbead
         pot(l) = vstate(istate_tfs(l),istate_tfs(l),l)
      end do

!-----------------------------------------------------------------------
!     /*   total potential                                            */
!-----------------------------------------------------------------------

      potential = 0.d0

      do l = 1, nbead
         potential = potential + pot(l)
      end do

      potential = potential / nbead

!-----------------------------------------------------------------------
!     /*   forces                                                     */
!-----------------------------------------------------------------------

      do l = 1, nbead
      do k = 1, natom
         fx(k,l) = - gxstate(istate_tfs(l),istate_tfs(l),k,l)
         fy(k,l) = - gystate(istate_tfs(l),istate_tfs(l),k,l)
         fz(k,l) = - gzstate(istate_tfs(l),istate_tfs(l),k,l)
      end do
      end do

!-----------------------------------------------------------------------
!     /*   nonadiabatic coupling vector                               */
!-----------------------------------------------------------------------

      call checkphase_MPI

      return
      end
