!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Nov 10, 2018 by M. Shiga
!      Description:     harmonic forces for path integrals
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine getforce_ref_xyz
!***********************************************************************
!=======================================================================
!
!     calculate reference harmonic force
!
!=======================================================================

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   fux_ref, fuy_ref, fuz_ref, physmass, omega_p2, x, y, z, &
     &   natom, nbead

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer :: i, j
      real(8) :: factx, facty, factz

!-----------------------------------------------------------------------
!     /*   centroid force in reference system is zero                 */
!-----------------------------------------------------------------------

      if ( nbead .eq. 1 ) then

         do i = 1, natom
            fux_ref(i,1) = 0.d0
            fuy_ref(i,1) = 0.d0
            fuz_ref(i,1) = 0.d0
         end do

      else if ( nbead .eq. 2 ) then

         do i = 1, natom
            factx = 2.d0*x(i,1) - 2.d0*x(i,2)
            facty = 2.d0*y(i,1) - 2.d0*y(i,2)
            factz = 2.d0*z(i,1) - 2.d0*z(i,2)
            fux_ref(i,1) = - physmass(i)*omega_p2*factx
            fuy_ref(i,1) = - physmass(i)*omega_p2*facty
            fuz_ref(i,1) = - physmass(i)*omega_p2*factz
            factx = 2.d0*x(i,2) - 2.d0*x(i,1)
            facty = 2.d0*y(i,2) - 2.d0*y(i,1)
            factz = 2.d0*z(i,2) - 2.d0*z(i,1)
            fux_ref(i,2) = - physmass(i)*omega_p2*factx
            fuy_ref(i,2) = - physmass(i)*omega_p2*facty
            fuz_ref(i,2) = - physmass(i)*omega_p2*factz
         end do

      else

         do j = 2, nbead-1
         do i = 1, natom
            factx = 2.d0*x(i,j) - x(i,j+1) - x(i,j-1)
            facty = 2.d0*y(i,j) - y(i,j+1) - y(i,j-1)
            factz = 2.d0*z(i,j) - z(i,j+1) - z(i,j-1)
            fux_ref(i,j) = - physmass(i)*omega_p2*factx
            fuy_ref(i,j) = - physmass(i)*omega_p2*facty
            fuz_ref(i,j) = - physmass(i)*omega_p2*factz
         end do
         end do

         do i = 1, natom
            factx = 2.d0*x(i,1) - x(i,2) - x(i,nbead)
            facty = 2.d0*y(i,1) - y(i,2) - y(i,nbead)
            factz = 2.d0*z(i,1) - z(i,2) - z(i,nbead)
            fux_ref(i,1) = - physmass(i)*omega_p2*factx
            fuy_ref(i,1) = - physmass(i)*omega_p2*facty
            fuz_ref(i,1) = - physmass(i)*omega_p2*factz
         end do

         do i = 1, natom
            factx = 2.d0*x(i,nbead) - x(i,1) - x(i,nbead-1)
            facty = 2.d0*y(i,nbead) - y(i,1) - y(i,nbead-1)
            factz = 2.d0*z(i,nbead) - z(i,1) - z(i,nbead-1)
            fux_ref(i,nbead) = - physmass(i)*omega_p2*factx
            fuy_ref(i,nbead) = - physmass(i)*omega_p2*facty
            fuz_ref(i,nbead) = - physmass(i)*omega_p2*factz
         end do

      end if

      return
      end

