!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Nov 10, 2018 by M. Shiga
!      Description:     harmonic forces in multiple time scale method
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine getforce_ref_me_p
!***********************************************************************
!=======================================================================
!
!     calculate reference harmonic force
!
!=======================================================================

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   fux_ref, fuy_ref, fuz_ref, omega_p2, ux, uy, uz, dnmmass, &
     &   natom, nbead

      use qmmm_variables, only : &
     &   layer

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer :: imode, iatom

!-----------------------------------------------------------------------
!     /*   centroid force in reference system is zero                 */
!-----------------------------------------------------------------------

      do iatom = 1, natom

         if ( layer(iatom)(1:1) .ne. 'A' ) cycle

         fux_ref(iatom,1) = 0.d0
         fuy_ref(iatom,1) = 0.d0
         fuz_ref(iatom,1) = 0.d0

      end do

!-----------------------------------------------------------------------
!     /*   non-centroid forces                                        */
!-----------------------------------------------------------------------

      do imode = 2, nbead
      do iatom = 1, natom

         if ( layer(iatom)(1:1) .ne. 'A' ) cycle

         fux_ref(iatom,imode) = &
     &      - dnmmass(iatom,imode)*omega_p2*ux(iatom,imode)
         fuy_ref(iatom,imode) = &
     &      - dnmmass(iatom,imode)*omega_p2*uy(iatom,imode)
         fuz_ref(iatom,imode) = &
     &      - dnmmass(iatom,imode)*omega_p2*uz(iatom,imode)

      end do
      end do

      return
      end





!***********************************************************************
      subroutine getforce_ref_me_s
!***********************************************************************
!=======================================================================
!
!     calculate reference harmonic force
!
!=======================================================================

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   fux_ref, fuy_ref, fuz_ref, omega_p2, ux, uy, uz, dnmmass, &
     &   natom, nbead

      use qmmm_variables, only : &
     &   layer

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer :: imode, iatom

!-----------------------------------------------------------------------
!     /*   centroid force in reference system is zero                 */
!-----------------------------------------------------------------------

      do iatom = 1, natom

         if ( layer(iatom)(1:1) .ne. 'B' ) cycle

         fux_ref(iatom,1) = 0.d0
         fuy_ref(iatom,1) = 0.d0
         fuz_ref(iatom,1) = 0.d0

      enddo

!-----------------------------------------------------------------------
!     /*   non-centroid forces                                        */
!-----------------------------------------------------------------------

      do imode = 2, nbead
      do iatom = 1, natom

         if ( layer(iatom)(1:1) .ne. 'B' ) cycle

         fux_ref(iatom,imode) = &
     &      - dnmmass(iatom,imode)*omega_p2*ux(iatom,imode)
         fuy_ref(iatom,imode) = &
     &      - dnmmass(iatom,imode)*omega_p2*uy(iatom,imode)
         fuz_ref(iatom,imode) = &
     &      - dnmmass(iatom,imode)*omega_p2*uz(iatom,imode)

      end do
      end do

      return
      end
