!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga, H. Kimizuka
!      Last updated:    Jan 23, 2025 by M. Shiga
!      Description:     extensive MPI parallelization
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine getforce_ref_XMPI
!***********************************************************************
!=======================================================================
!
!     calculate reference harmonic force
!
!=======================================================================
!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   ux, uy, uz, fux_ref, fuy_ref, fuz_ref, omega_p2, dnmmass

      use XMPI_variables, only : &
     &   jstart_bead, jend_bead, jstart_atom, jend_atom

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer :: iatom, imode

!-----------------------------------------------------------------------
!     /*   centroid and non-centroid forces                           */
!-----------------------------------------------------------------------

      do imode = jstart_bead, jend_bead

         if ( imode .eq. 1 ) then

            do iatom = jstart_atom, jend_atom
               fux_ref(iatom,imode) = 0.d0
               fuy_ref(iatom,imode) = 0.d0
               fuz_ref(iatom,imode) = 0.d0
            end do

         else

            do iatom = jstart_atom, jend_atom
               fux_ref(iatom,imode) = &
     &            - dnmmass(iatom,imode)*omega_p2*ux(iatom,imode)
               fuy_ref(iatom,imode) = &
     &            - dnmmass(iatom,imode)*omega_p2*uy(iatom,imode)
               fuz_ref(iatom,imode) = &
     &            - dnmmass(iatom,imode)*omega_p2*uz(iatom,imode)
            end do

         end if

      end do

      return
      end
