!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Nov 10, 2018 by M. Shiga
!      Description:     harmonic forces for path integrals
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine getforce_ref
!***********************************************************************
!-----------------------------------------------------------------------
!
!     calculate reference harmonic force
!
!-----------------------------------------------------------------------

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   ux, uy, uz, fux_ref, fuy_ref, fuz_ref, omega_p2, &
     &   dnmmass, natom, nbead

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer :: iatom, imode

!-----------------------------------------------------------------------
!     /*   centroid force in reference system is zero                 */
!-----------------------------------------------------------------------

      do iatom = 1, natom
         fux_ref(iatom,1) = 0.d0
         fuy_ref(iatom,1) = 0.d0
         fuz_ref(iatom,1) = 0.d0
      enddo

!-----------------------------------------------------------------------
!     /*   non-centroid forces                                        */
!-----------------------------------------------------------------------

      do imode = 2, nbead
      do iatom = 1, natom

        fux_ref(iatom,imode) = &
     &     - dnmmass(iatom,imode)*omega_p2*ux(iatom,imode)
        fuy_ref(iatom,imode) = &
     &     - dnmmass(iatom,imode)*omega_p2*uy(iatom,imode)
        fuz_ref(iatom,imode) = &
     &     - dnmmass(iatom,imode)*omega_p2*uz(iatom,imode)

      end do
      end do

      return
      end

