!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Nov 10, 2018 by M. Shiga
!      Description:     forces in mean field Ehrenfest dynamics
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine getforce_mfe_MPI
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   fx, fy, fz, pot, potential, nbead, ipotential, natom

      use multistate_variables, only : &
     &   vstate, gxstate, gystate, gzstate, dxstate, dystate, dzstate, &
     &   dipxstate, dipystate, dipzstate, cstate, nstate

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer :: i, j, k, l

!-----------------------------------------------------------------------
!     /*   start                                                      */
!-----------------------------------------------------------------------

!     /*   potential   */
      vstate(:,:,:) = 0.d0

!     /*   forces   */
      gxstate(:,:,:,:) = 0.d0
      gystate(:,:,:,:) = 0.d0
      gzstate(:,:,:,:) = 0.d0

!     /*   forces   */
      dxstate(:,:,:,:) = 0.d0
      dystate(:,:,:,:) = 0.d0
      dzstate(:,:,:,:) = 0.d0

!     /*   dipole moment   */
      dipxstate(:,:)   = 0.d0
      dipystate(:,:)   = 0.d0
      dipzstate(:,:)   = 0.d0

!-----------------------------------------------------------------------
!     /*   calculate nonadiabatic potential                           */
!     /*      input  = x, y, z                                        */
!     /*      output = vstate, gxstate, gystate, gzstate,             */
!     /*               dxstate, dystate, dzstate                      */
!-----------------------------------------------------------------------

!     ===  molpro  ===

      if      ( ipotential(1:7) .eq. 'MOLPRO ' ) then

         call force_molpro_MPI

!     ===  tully's model  ===

      else if ( ipotential(1:6) .eq. 'TULLY ' ) then

         call force_tully_MPI

!     ===  error  ===

      else

         call error_handling_MPI( 1, 'subroutine getforce_mfe_MPI', 27 )

      end if

!-----------------------------------------------------------------------
!     /*   potential                                                  */
!-----------------------------------------------------------------------

      pot(:) = 0.d0

      do l = 1, nbead
      do j = 1, nstate
      do i = 1, nstate
         pot(l) = pot(l) &
     &          + dreal( dconjg(cstate(i,l))*vstate(i,j,l)*cstate(j,l) )
      end do
      end do
      end do

!-----------------------------------------------------------------------
!     /*   total potential                                            */
!-----------------------------------------------------------------------

      potential = 0.d0

      do l = 1, nbead
         potential = potential + pot(l)
      end do

      potential = potential / nbead

!-----------------------------------------------------------------------
!     /*   forces                                                     */
!-----------------------------------------------------------------------

      do l = 1, nbead
      do k = 1, natom

         fx(k,l) = 0.d0
         fy(k,l) = 0.d0
         fz(k,l) = 0.d0

         do j = 1, nstate
         do i = 1, nstate

            fx(k,l) = fx(k,l) &
     &              - dreal( dconjg(cstate(i,l))*gxstate(i,j,k,l) &
     &                       *cstate(j,l) )
            fy(k,l) = fy(k,l) &
     &              - dreal( dconjg(cstate(i,l))*gystate(i,j,k,l) &
     &                       *cstate(j,l) )
            fz(k,l) = fz(k,l) &
     &              - dreal( dconjg(cstate(i,l))*gzstate(i,j,k,l) &
     &                       *cstate(j,l) )

            fx(k,l) = fx(k,l) &
     &              + dreal( dconjg(cstate(i,l))*dxstate(i,j,k,l) &
     &                       *vstate(i,i,l)*cstate(j,l) )
            fx(k,l) = fx(k,l) &
     &              - dreal( dconjg(cstate(i,l))*dxstate(i,j,k,l) &
     &                       *vstate(j,j,l)*cstate(j,l) )
            fy(k,l) = fy(k,l) &
     &              + dreal( dconjg(cstate(i,l))*dystate(i,j,k,l) &
     &                       *vstate(i,i,l)*cstate(j,l) )
            fy(k,l) = fy(k,l) &
     &              - dreal( dconjg(cstate(i,l))*dystate(i,j,k,l) &
     &                       *vstate(j,j,l)*cstate(j,l) )
            fz(k,l) = fz(k,l) &
     &              + dreal( dconjg(cstate(i,l))*dzstate(i,j,k,l) &
     &                       *vstate(i,i,l)*cstate(j,l) )
            fz(k,l) = fz(k,l) &
     &              - dreal( dconjg(cstate(i,l))*dzstate(i,j,k,l) &
     &                       *vstate(j,j,l)*cstate(j,l) )

         end do
         end do

      end do
      end do

!-----------------------------------------------------------------------
!     /*   nonadiabatic coupling vector                               */
!-----------------------------------------------------------------------

      call checkphase_MPI

      return
      end
