!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Nov 10, 2018 by M. Shiga
!      Description:     calculate energy and force in QM/MM
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine getforce_me_p_MPI
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   shared variables from PIMD                                 */
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   tnm, natom, nbead

      use qmmm_variables, only : &
     &   pot_a, fx_a, fy_a, fz_a, vir_a, dipx_a, dipy_a, dipz_a, &
     &   potential_a, fux_a, fuy_a, fuz_a, natom_p, natom_l

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      real(8) :: dp

      integer :: i, j, k

!-----------------------------------------------------------------------
!     /*   initialize                                                 */
!-----------------------------------------------------------------------

      pot_a(:)   = 0.d0

      fx_a(:,:)  = 0.d0
      fy_a(:,:)  = 0.d0
      fz_a(:,:)  = 0.d0

      vir_a(:,:) = 0.d0

      dipx_a(:)  = 0.d0
      dipy_a(:)  = 0.d0
      dipz_a(:)  = 0.d0

!-----------------------------------------------------------------------
!     /*   qm part from SMASH                                         */
!-----------------------------------------------------------------------

      if ( natom_p+natom_l .gt. 0 ) call force_me_qmpart_MPI

!-----------------------------------------------------------------------
!     /*   potential and force are divided by nbead                   */
!-----------------------------------------------------------------------

      dp = dble(nbead)

      potential_a = 0.d0

      do j = 1, nbead

         potential_a = potential_a + pot_a(j)

         do i = 1, natom

            fx_a(i,j) = fx_a(i,j)/dp
            fy_a(i,j) = fy_a(i,j)/dp
            fz_a(i,j) = fz_a(i,j)/dp

         end do

      end do

      potential_a = potential_a/dp

      do j = 1, 3
      do i = 1, 3
         vir_a(i,j) = vir_a(i,j)/dp
      end do
      end do

!-----------------------------------------------------------------------
!     /*   Cartesian   -->   normal mode                              */
!-----------------------------------------------------------------------

      do i = 1, nbead
      do k = 1, natom
         fux_a(k,i) = 0.d0
         fuy_a(k,i) = 0.d0
         fuz_a(k,i) = 0.d0
      end do
      end do

      do k = 1, natom
      do i = 1, nbead
      do j = 1, nbead
         fux_a(k,i) = fux_a(k,i) + fx_a(k,j)*tnm(j,i)
         fuy_a(k,i) = fuy_a(k,i) + fy_a(k,j)*tnm(j,i)
         fuz_a(k,i) = fuz_a(k,i) + fz_a(k,j)*tnm(j,i)
      end do
      end do
      end do

      return
      end





!***********************************************************************
      subroutine getforce_me_s_MPI
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   shared variables from PIMD                                 */
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   tnm, natom, nbead

      use qmmm_variables, only : &
     &   pot_b, fx_b, fy_b, fz_b, vir_b, dipx_b, dipy_b, dipz_b, &
     &   fux_b, fuy_b, fuz_b, potential_b, natom_s

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      real(8) :: dp

      integer :: i, j, k

!-----------------------------------------------------------------------
!     /*   initialize                                                 */
!-----------------------------------------------------------------------

      pot_b(:)   = 0.d0

      fx_b(:,:)  = 0.d0
      fy_b(:,:)  = 0.d0
      fz_b(:,:)  = 0.d0

      vir_b(:,:) = 0.d0

      dipx_b(:)  = 0.d0
      dipy_b(:)  = 0.d0
      dipz_b(:)  = 0.d0

!-----------------------------------------------------------------------
!     /*   mm part from PIMD                                          */
!-----------------------------------------------------------------------

      if ( natom_s .gt. 0 ) call force_me_mmpart_MPI

!-----------------------------------------------------------------------
!     /*   external force                                             */
!-----------------------------------------------------------------------

      call force_me_external_s_MPI

!-----------------------------------------------------------------------
!     /*   potential and force are divided by nbead                   */
!-----------------------------------------------------------------------

      dp = dble(nbead)

      potential_b = 0.d0

      do j = 1, nbead

         potential_b = potential_b + pot_b(j)

         do i = 1, natom

            fx_b(i,j) = fx_b(i,j)/dp
            fy_b(i,j) = fy_b(i,j)/dp
            fz_b(i,j) = fz_b(i,j)/dp

         end do

      end do

      potential_b = potential_b/dp

      do j = 1, 3
      do i = 1, 3
         vir_b(i,j) = vir_b(i,j)/dp
      end do
      end do

!-----------------------------------------------------------------------
!     /*   Cartesian   -->   normal mode                              */
!-----------------------------------------------------------------------

      do i = 1, nbead
      do k = 1, natom
         fux_b(k,i) = 0.d0
         fuy_b(k,i) = 0.d0
         fuz_b(k,i) = 0.d0
      end do
      end do

      do k = 1, natom
      do i = 1, nbead
      do j = 1, nbead
         fux_b(k,i) = fux_b(k,i) + fx_b(k,j)*tnm(j,i)
         fuy_b(k,i) = fuy_b(k,i) + fy_b(k,j)*tnm(j,i)
         fuz_b(k,i) = fuz_b(k,i) + fz_b(k,j)*tnm(j,i)
      end do
      end do
      end do

      return
      end





!***********************************************************************
      subroutine getforce_me_sum_MPI
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   potential, pot, fx, fy, fz, dipx, dipy, dipz, vir, &
     &   fux, fuy, fuz, istep, natom, nbead, iounit, myrank

      use qmmm_variables, only : &
     &   potential_a, potential_b, pot_a, pot_b, &
     &   fx_a, fy_a, fz_a, fx_b, fy_b, fz_b, &
     &   dipx_a, dipy_a, dipz_a, dipx_b, dipy_b, dipz_b, &
     &   vir_a, vir_b, fux_a, fuy_a, fuz_a, &
     &   fux_b, fuy_b, fuz_b, &
     &   iprint_qmmm

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer :: i, j

!-----------------------------------------------------------------------
!     /*   start                                                      */
!-----------------------------------------------------------------------

      potential = potential_a + potential_b

      do j = 1, nbead
         pot(j) = pot_a(j) + pot_b(j)
      end do

      do j = 1, nbead
      do i = 1, natom
         fx(i,j) = fx_a(i,j) + fx_b(i,j)
         fy(i,j) = fy_a(i,j) + fy_b(i,j)
         fz(i,j) = fz_a(i,j) + fz_b(i,j)
      end do
      end do

      do j = 1, nbead
      do i = 1, natom
         fux(i,j) = fux_a(i,j) + fux_b(i,j)
         fuy(i,j) = fuy_a(i,j) + fuy_b(i,j)
         fuz(i,j) = fuz_a(i,j) + fuz_b(i,j)
      end do
      end do

      do j = 1, 3
      do i = 1, 3
         vir(i,j) = vir_a(i,j) + vir_b(i,j)
      end do
      end do

!-----------------------------------------------------------------------
!     /*   apply virial correction                                    */
!-----------------------------------------------------------------------

      call correct_virial

!-----------------------------------------------------------------------
!     /*   correct forces on centroid                                 */
!-----------------------------------------------------------------------

      call correct_force_MPI

!-----------------------------------------------------------------------
!     /*   dipole moment                                              */
!-----------------------------------------------------------------------

      do j = 1, nbead
         dipx(j) = dipx_a(j) + dipx_b(j)
         dipy(j) = dipy_a(j) + dipy_b(j)
         dipz(j) = dipz_a(j) + dipz_b(j)
      end do

!-----------------------------------------------------------------------
!     /*   print energies                                             */
!-----------------------------------------------------------------------

      if ( myrank .eq. 0 ) then

      if ( iprint_qmmm .gt. 0 ) then
      if ( mod(istep,iprint_qmmm) .eq. 0 ) then

      open ( iounit, file = 'qmmm.out', access = 'append' )

      do i = 1, nbead
         write( iounit, '(i8,2f16.8)' ) istep, pot_a(i), pot_b(i)
      end do

      close( iounit )

      end if
      end if

      end if

      return
      end
