!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Nov 10, 2018 by M. Shiga
!      Description:     box gradient
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine getfbox
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   box, boxinv, vir, fbox

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer :: i, j, k

      real(8) :: sum

!-----------------------------------------------------------------------
!     /*   start                                                      */
!-----------------------------------------------------------------------

!     /*   force calculation   */
      call getforce

!     /*   get inverse matrix   */
      call inv3 ( box, boxinv )

!     /*   get fbox from virial   */

      do i = 1, 3
      do j = 1, 3
         sum = 0.d0
         do k = 1, 3
            sum = sum + vir(i,k)*boxinv(j,k)
         end do
         fbox(i,j) = sum
      end do
      end do

      return
      end

