!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga, H. Kimizuka
!      Last updated:    Jan 7, 2019 by M. Shiga
!      Description:     clock routine
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine getdate
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : char_date

      implicit none
      character(len=8) :: date
      character(len=10) :: time
      character(len=5) :: zone
      integer, dimension(8) :: values
      character(len=3) :: dow

!-----------------------------------------------------------------------
!     /*   start                                                      */
!-----------------------------------------------------------------------

      call date_and_time(date,time,zone,values)

      call day_of_week(values(1),values(2),values(3),dow)

!
! ... layouted as 'date +"%Y-%m-%d %a %H:%M:%S.%N"'
!
      char_date = date(1:4) // "-" // &
     &            date(5:6) // "-" // &
     &            date(7:8) // " " // &
     &            dow(1:3)  // " " // &
     &            time(1:2) // ":" // &
     &            time(3:4) // ":" // &
     &            time(5:10)

      return
      end

      subroutine day_of_week(y,m,d,dow)

      implicit none

      integer :: y, m, d
      character(len=3) :: dow
      integer :: n, tmp

!
! ... Zeller's congruence for the Gregorian calendar
!
      if (m .le. 2) then
        y = y - 1
        m = m + 12
      end if

      tmp = y + y/4 - y/100 + y/400 + (13*m+8)/5 + d

      n = mod(tmp,7)

      select case (n)
      case (0)
         dow = "Sun"
      case (1)
         dow = "Mon"
      case (2)
         dow = "Tue"
      case (3)
         dow = "Wed"
      case (4)
         dow = "Thu"
      case (5)
         dow = "Fri"
      case (6)
         dow = "Sat"
      case default
         dow = "   "
      end select

      return
      end
