!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Nov 21, 2018 by M. Shiga
!      Description:     BEST method
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine get_v_best( ierr )
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   pi, beta

      use best_variables, only : &
     &   gbuf, dgbuf, sbuf, dloggbuf, hbuf, dhbuf, v_best, dv_best, &
     &   s_best, s_best_max, s_best_min, s_best_hi, s_best_lo, &
     &   s_best_border, f_best, r_best, alpha_best, eps_best, &
     &   s_sort, num_sort, nsbest_buf, iocc, nbest_buf, nbest_buf_max, &
     &   nc_buf_max, npbest_buf, nc_buf, ibuf, ival, inum, npbest, nbest

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

!     /*   initialize variables   */
      implicit none

!     /*   real numbers   */
      real(8) :: hbuf_sum, ds, df1, df2, dj

!     /*   integers   */
      integer :: i, j, k, l, m, iflag, ierr

!     /*   integers   */
      integer, save :: iset = 0

!     /*   large value */
      integer :: large_value = 100000

!     /*   cut off   */
      real(8) :: cutoff

!-----------------------------------------------------------------------
!     /*   initialize                                                 */
!-----------------------------------------------------------------------

!     /*   bias potential   */
      v_best = 0.d0

!     /*   derivative of bias potential  */
      dv_best(:) = 0.d0

!-----------------------------------------------------------------------
!     /*   maximum s value within primary region                      */
!-----------------------------------------------------------------------

      s_best_max = maxval( s_best(1:npbest) )

!-----------------------------------------------------------------------
!     /*   maximum s value within secondary region                    */
!-----------------------------------------------------------------------

      s_best_min = minval( s_best(npbest+1:nbest) )

!-----------------------------------------------------------------------
!     /*   identify the border atom                                   */
!-----------------------------------------------------------------------

      do i = 1, nbest
         num_sort(i) = i
         s_sort(i) = s_best(i)
      end do

      call quicksort ( s_sort, num_sort, nbest )

      s_best_border = s_sort(npbest)

!-----------------------------------------------------------------------
!     /*   check error                                                */
!-----------------------------------------------------------------------

!     /*   initialize error flag   */
      ierr = 0

!c     /*   check error   */
!      if ( (s_best_max-s_best_min) .gt. (3.d0*r_best) ) then
!
!c        /*   error flag   */
!         ierr = 1
!
!c        /*   quit   */
!         return
!
!c     /*   check error   */
!      end if

!-----------------------------------------------------------------------
!     /*   maximum edge of buffer region                              */
!-----------------------------------------------------------------------

      s_best_hi = max( s_best_border + r_best, s_best_max )

!-----------------------------------------------------------------------
!     /*   minimum edge of buffer region                              */
!-----------------------------------------------------------------------

      s_best_lo = min( s_best_border - r_best, s_best_min )

!-----------------------------------------------------------------------
!     /*   number of buffer atoms in the primary subsystem            */
!-----------------------------------------------------------------------

!     //   reset counter
      j = 0

!     //   loop of solvent atoms in primary region
      do i = 1, npbest

!        //   count those with s higher than the buffer edge
         if ( s_best(i) .ge. s_best_lo ) j = j + 1

!     //   loop of solvent atoms in primary region
      end do

!     //   number of buffer atoms in primary region
      npbest_buf = j

!-----------------------------------------------------------------------
!     /*   number of buffer atoms in the secondary subsystem          */
!-----------------------------------------------------------------------

!     //   reset counter
      j = npbest_buf

!     //   loop of solvent atoms in secondary region
      do i = npbest+1, nbest

!        //   count those with s lower than the buffer edge
         if ( s_best(i) .le. s_best_hi ) j = j + 1

!     //   loop of solvent atoms in secondary region
      end do

!     //   total number of buffer atoms
      nbest_buf = j

!-----------------------------------------------------------------------
!     /*   number of buffer atoms in secondary region                 */
!-----------------------------------------------------------------------

!     //   number of buffer atoms in secondary region
      nsbest_buf = nbest_buf - npbest_buf

!-----------------------------------------------------------------------
!     /*   do nothing if there is no buffer atom                      */
!-----------------------------------------------------------------------

      if ( nbest_buf .eq. 0 ) return

!-----------------------------------------------------------------------
!     /*   count number of exchange combinations                      */
!-----------------------------------------------------------------------

!     //   number of buffer atoms
      dj = dble(nbest_buf)

!     //   number of buffer atoms in primary or secondary region
      k = min(npbest_buf,nsbest_buf)

!     //   count number of combinations of exchanging buffer atoms

      do i = 1, k-1
         dj = dj  * dble(nbest_buf-i) / dble(i+1)
      end do

!     //   final number of combinations
      nc_buf = nint(dj)

!-----------------------------------------------------------------------
!     /*   error termination if buffer size is too large              */
!-----------------------------------------------------------------------

!     //   reset flag
      ierr = 0

!     //   if number of combinations is too large
      if ( nc_buf .gt. large_value ) then

!        //   error flag
         ierr = 2

!        //   go back and terminate run
         return

!     //   if number of combinations is too large
      end if

!-----------------------------------------------------------------------
!     /*   whenever buffer is bigger reallocate memory                */
!-----------------------------------------------------------------------

!     //   reset flag
      iflag = 0

!     //   allocation on initial setting

      if ( iset .eq. 0 ) then
         iflag = 1
         iset = 1
      end if

!     //   reallocation when number of buffer atoms is bigger

      if ( nbest_buf .gt. nbest_buf_max ) then
         nbest_buf_max = nbest_buf
         iflag = 1
      end if

!     //   reallocation when number of combinations is bigger

      if ( nc_buf .gt. nc_buf_max ) then
         nc_buf_max = nc_buf
         iflag = 1
      end if

!     //   memory reallocation

      if ( iflag .eq. 1 ) then

         if ( allocated( gbuf ) )      deallocate( gbuf )
         if ( allocated( dgbuf ) )     deallocate( dgbuf )
         if ( allocated( sbuf ) )      deallocate( sbuf )
         if ( allocated( ibuf ) )      deallocate( ibuf )
         if ( allocated( ival ) )      deallocate( ival )
         if ( allocated( iocc ) )      deallocate( iocc )
         if ( allocated( inum ) )      deallocate( inum )
         if ( allocated( dloggbuf ) )  deallocate( dloggbuf )
         if ( allocated( hbuf ) )      deallocate( hbuf )
         if ( allocated( dhbuf ) )     deallocate( dhbuf )

         allocate( gbuf(nbest_buf_max,nbest_buf_max) )
         allocate( dgbuf(2,nbest_buf_max,nbest_buf_max) )
         allocate( sbuf(nbest_buf_max) )
         allocate( ibuf(nbest_buf_max) )
         allocate( ival(nbest_buf_max) )
         allocate( iocc(nbest_buf_max,nc_buf_max) )
         allocate( inum(nbest_buf_max,nc_buf_max) )
         allocate( dloggbuf(nbest_buf_max) )
         allocate( hbuf(nc_buf_max) )
         allocate( dhbuf(nbest_buf_max,nc_buf_max) )

      end if

!-----------------------------------------------------------------------
!     /*   set coordinates of buffer atoms                            */
!-----------------------------------------------------------------------

!     //   reset counter
      j = 0

!     //   loop of solvent atoms in primary region
      do i = 1, npbest

!        //   find those with s higher than the buffer edge
         if ( s_best(i) .ge. s_best_lo ) then

!           //   update counter
            j = j + 1

!           //   substitute s of buffer atom
            sbuf(j) = s_best(i)

!           //   substitute id of buffer atom
            ibuf(j) = i

!        //   count those with s higher than the buffer edge
         end if

!     //   loop of solvent atoms in primary region
      end do

!     //   number of buffer atoms in primary region
      j = npbest_buf

!     //   loop of solvent atoms in secondary region
      do i = npbest+1, nbest

!        //   find those with s lower than the buffer edge
         if ( s_best(i) .le. s_best_hi ) then

!           //   update counter
            j = j + 1

!           //   substitute s of buffer atom
            sbuf(j) = s_best(i)

!           //   substitute id of buffer atom
            ibuf(j) = i

         end if

!     //   loop of solvent atoms in secondary region
      end do

!-----------------------------------------------------------------------
!     /*   g function and its derivatives                             */
!-----------------------------------------------------------------------

!     //   cut off parameter
      cutoff = - log ( beta * eps_best )

!     //   loop of solvent atom pair
      do i = 1, nbest_buf
      do j = 1, nbest_buf

!        //   id of buffer atoms
         k = ibuf(i)
         l = ibuf(j)

!        //   difference of s values
         ds = s_best(k) - s_best(l)

!        //   if ds is positive
         if ( ds .gt. 0.d0 ) then

!           //   calculate g function and its derivatives
            call get_gbuf_best &
     &         ( i, j, ds, gbuf, dgbuf, nbest_buf_max, &
     &         alpha_best, cutoff )
!
!        //   if ds is negative
         else

!           //   g function is one
            gbuf(i,j)    = 1.d0

!           //   derivative of g function is zero
            dgbuf(1,i,j) = 0.d0
            dgbuf(2,i,j) = 0.d0

!        //   end of if statement
         end if

!     //   loop of solvent atom pair
      end do
      end do

!-----------------------------------------------------------------------
!     /*   generate exchange combinations of buffer atoms             */
!-----------------------------------------------------------------------

!     //   initialize i
      i = 0

!     //   iocc: occupancy of buffer atoms in primary region

      call get_iocc &
     &   ( i, ival, iocc, m, nc_buf_max, npbest_buf, nbest_buf, &
     &     nbest_buf_max )

!     //   combination number of occupancy exchanges
      nc_buf = m

!     //   inum: atom number after occupancy exchanges

      call get_inum &
     &   ( iocc, inum, nc_buf, nc_buf_max, nbest_buf, nbest_buf_max )

!-----------------------------------------------------------------------
!     /*   h function                                                 */
!-----------------------------------------------------------------------

!     //   initialize sum of h functions
      hbuf_sum = 0.d0

!     //   loop of occupancy exchanges
      do m = 1, nc_buf

!        //   initialize h function
         hbuf(m) = 1.d0

!        //   buffer atom pairs in primary and secondary regions

         do i = 1, npbest_buf
         do j = npbest_buf+1, nbest_buf

!           //   pair of atom numbers

            k = inum(i,m)
            l = inum(j,m)

!           //   h function is a product of g functions
            hbuf(m) = hbuf(m) * gbuf(k,l)

!        //   buffer atom pairs in primary and secondary regions

         end do
         end do

!        //   sum of h functions
         hbuf_sum = hbuf_sum + hbuf(m)

!     //   loop of occupancy exchanges
      end do

!-----------------------------------------------------------------------
!     /*   bias function                                              */
!-----------------------------------------------------------------------

!     /*   f function   */
      f_best = hbuf(1) / hbuf_sum

!     /*   potential shift   */
      v_best = - log(f_best) / beta

!-----------------------------------------------------------------------
!     /*   h derivatives                                              */
!-----------------------------------------------------------------------

!     //   loop of occupancy exchanges
      do m = 1, nc_buf

!        //  initialize
         dloggbuf(:) = 0.d0

!        //   buffer atom pairs in primary and secondary regions

         do i = 1, npbest_buf
         do j = npbest_buf+1, nbest_buf

!           //   pair of atom numbers

            k = inum(i,m)
            l = inum(j,m)

!           //   log derivative of g function

            if ( gbuf(k,l) .eq. 0.d0 ) then
               dloggbuf(k) = 0.d0
               dloggbuf(l) = 0.d0
            else
               dloggbuf(k) = dloggbuf(k) + dgbuf(1,k,l) / gbuf(k,l)
               dloggbuf(l) = dloggbuf(l) + dgbuf(2,k,l) / gbuf(k,l)
            end if

!        //   buffer atom pairs in primary and secondary regions

         end do
         end do

!        //   derivative of h function

         do k = 1, nbest_buf
            dhbuf(k,m) = hbuf(m) * dloggbuf(k)
         end do

!     //   loop of occupancy exchanges
      end do

!-----------------------------------------------------------------------
!     /*   derivative of bias function                                */
!-----------------------------------------------------------------------

!     //   loop of buffer atoms
      do k = 1, nbest_buf

!        //   derivative of numerator part
         df1 = dhbuf(k,1) / hbuf(1)

!        //   derivative of denominator part

         df2 = 0.d0

         do m = 1, nc_buf
            df2 = df2 + dhbuf(k,m)
         end do

         df2 = df2 / hbuf_sum

!        //   buffer atom
         i = ibuf(k)

!        //   combine numerator and denominator parts
         dv_best(i) = - ( df1 - df2 ) / beta

!     //   loop of buffer atoms
      end do

      return
      end





!***********************************************************************
      subroutine get_gbuf_best &
     &    ( i, j, ds, gbuf, dgbuf, nbest_buf_max, alpha_best, cutoff )
!***********************************************************************

!     //   local variables
      implicit none

!     //   buffer size
      integer :: nbest_buf_max

!     //   g function
      real(8) :: gbuf(nbest_buf_max,nbest_buf_max)

!     //   derivative of g function
      real(8) :: dgbuf(2,nbest_buf_max,nbest_buf_max)

!     //   exponent
      real(8) :: alpha_best

!     //   cut off
      real(8) :: cutoff

!     //   real numbers
      real(8) :: ds, factor, factor_2

!     //   integers
      integer :: i, j

!     //   exponential factor
      factor = alpha_best * ds * ds

!     //   calculate g function and its derivatives
      if ( factor .lt. cutoff ) then

!        //   g function
         gbuf(i,j) = exp( - factor )

!        //   derivative of g function
         factor_2 = 2.d0 * alpha_best * ds * gbuf(i,j)

!        //   derivative of g function
         dgbuf(1,i,j) = - factor_2
         dgbuf(2,i,j) = + factor_2

!     //   when factor is large, g function is zero
      else

!        //   g function
         gbuf(i,j) = exp( - cutoff )

!        //   derivative of g function
         factor_2 = 2.d0 * alpha_best * ds * gbuf(i,j)

!        //   derivative of g function
         dgbuf(1,i,j) = - factor_2
         dgbuf(2,i,j) = + factor_2

!     //   end of if statement
      end if

      return
      end





!***********************************************************************
      recursive subroutine get_iocc &
     &   ( i, ival, iocc, m, nc_buf_max, npbest_buf, nbest_buf, &
     &     nbest_buf_max )
!***********************************************************************

      implicit none

      integer :: nc_buf_max, npbest_buf, nbest_buf, nbest_buf_max
      integer :: ival(nbest_buf_max)
      integer :: iocc(nbest_buf_max,nc_buf_max)
      integer :: i, j, m

      if ( i .eq. 0 ) then

         m = 0

         iocc(:,:) = 0

         i = i + 1

         do j = 1, nbest_buf

            ival(1) = j

            call get_iocc &
     &         ( i, ival, iocc, m, nc_buf_max, npbest_buf, &
     &           nbest_buf, nbest_buf_max )

         end do

         return

      end if

      if ( i .eq. npbest_buf ) then

         m = m + 1

         do j = 1, npbest_buf
            iocc(ival(j),m) = 1
         end do

      else

         i = i + 1

         do j = ival(i-1)+1, nbest_buf

            ival(i) = j

            call get_iocc &
     &         ( i, ival, iocc, m, nc_buf_max, npbest_buf, &
     &           nbest_buf, nbest_buf_max )

         end do

         i = i - 1

      end if

      return
      end





!***********************************************************************
      subroutine get_inum &
     &   ( iocc, inum, nc_buf, nc_buf_max, nbest_buf, nbest_buf_max )
!***********************************************************************

      implicit none

      integer :: nc_buf, nc_buf_max, nbest_buf, nbest_buf_max
      integer :: iocc(nbest_buf_max,nc_buf_max)
      integer :: inum(nbest_buf_max,nc_buf_max)
      integer :: i, j, m

      inum(:,:) = 0

      do m = 1, nc_buf

         j = 0

         do i = 1, nbest_buf

            if ( iocc(i,m) .eq. 1 ) then

               j = j + 1

               inum(j,m) = i

            end if

         end do

         do i = 1, nbest_buf

            if ( iocc(i,m) .eq. 0 ) then

               j = j + 1

               inum(j,m) = i

            end if

         end do

      end do

      return
      end





!***********************************************************************
      recursive subroutine quicksort( x, num, n )
!***********************************************************************

      integer, intent(in) :: n
      real(8), intent(inout) :: x(n)
      integer, intent(inout) :: num(n)

      integer :: imin, imax, it, is
      real(8) :: p, xt

      if ( n .eq. 1 ) return

      p = x(1)

      imin = 1
      imax = n

      do while ( imin < imax )

         do while( x(imin) < p .and. imin < imax )
           imin = imin + 1
         end do

         do while( p <= x(imax) .and. imin < imax )
           imax = imax - 1
         end do

         if ( imin < imax ) then
           xt = x(imax)
           x(imax) = x(imin)
           x(imin) = xt
           it = num(imax)
           num(imax) = num(imin)
           num(imin) = it
         end if

      end do

      is = imax - 1

      if (is .eq. 0 ) is = 1

      call quicksort( x(1:is), num(1:is), is )

      call quicksort( x(is+1:n), num(is+1:n), n-is )

      return
      end

