!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Nov 10, 2018 by M. Shiga
!      Description:     combination rule for lennard-jones pair
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine get_eps_ljpair( eps_i, eps_j, eps, epsrule_ljpair )
!***********************************************************************

      real(8) :: eps_i, eps_j, eps

      character(len=12) :: epsrule_ljpair

      if      ( epsrule_ljpair(1:10) .eq. 'GEOMETRIC ' ) then
         eps = sqrt( eps_i * eps_j )
      else if ( epsrule_ljpair(1:11) .eq. 'ARITHMETIC ' ) then
         eps = 0.5d0 * eps_i + 0.5d0 * eps_j
      else
         eps = sqrt( eps_i * eps_j )
      end if

      return
      end





!***********************************************************************
      subroutine get_sig_ljpair( sig_i, sig_j, sig, sigrule_ljpair )
!***********************************************************************

      real(8) :: sig_i, sig_j, sig

      character(len=12) :: sigrule_ljpair

      if      ( sigrule_ljpair(1:10) .eq. 'GEOMETRIC ' ) then
         sig = sqrt( sig_i * sig_j )
      else if ( sigrule_ljpair(1:11) .eq. 'ARITHMETIC ' ) then
         sig = 0.5d0 * sig_i + 0.5d0 * sig_j
      else
         sig = 0.5d0 * sig_i + 0.5d0 * sig_j
      end if

      return
      end
