!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Nov 10, 2018 by M. Shiga
!      Description:     error function and its derivatives
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      real(8) function erf_0(x)
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer :: i, j, ntab, nterm

      real(8) :: ax,  erftab, dtab, dx, factor, gerf, sqrtpi, &
     &           x, xtab, error_function

      parameter ( ntab = 6000, nterm = 5 )

      common /erfs/ erftab(0:ntab,0:nterm), dtab, sqrtpi

      integer, save :: isave = 0

!-----------------------------------------------------------------------
!     /*   initialize                                                 */
!-----------------------------------------------------------------------

      if ( isave .eq. 0 ) then

         dtab = 6.d0/dble(ntab)

         do i = 0, ntab
            xtab        = dble(i)*dtab
            erftab(i,0) = error_function(xtab)
            do j = 1, nterm
               erftab(i,j) = gerf(xtab,j)
            end do
         end do

         isave = 1

      end if

!-----------------------------------------------------------------------

      if ( x .eq. 0.d0 ) then

         erf_0 = 0.d0
         return

      end if

      ax     = abs(x)
      factor = x/ax
      i      = nint(ax/dtab)
      xtab   = dble(i)*dtab

      if ( xtab .ge. 6.d0 ) then

         erf_0 = 1.d0*factor
         return

      else

         dx  = ax - xtab

!         coeff = 1.d0
!         erf_0 =  erftab(i,0)
!         do j = 1, nterm
!            coeff = coeff*dx/dble(j)
!            erf_0 = erf_0 + coeff*erftab(i,j)
!         end do
!         erf_0 = erf_0*factor

         erf_0 = ( erftab(i,0) &
     &         + dx*(                        erftab(i,1) &
     &         + dx*0.5000000000000000d+00*( erftab(i,2) &
     &         + dx*0.3333333333333333d+00*( erftab(i,3) &
     &         + dx*0.2500000000000000d+00*( erftab(i,4) )))) )*factor

         return

      end if

      return
      end





!***********************************************************************
      real(8) function erf_1(x)
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer :: i, j, ntab, nterm

      real(8) :: ax,  erftab, dtab, dx, gerf, pi, sqrtpi, &
     &           x, xtab, error_function

      parameter ( ntab = 6000, nterm = 5 )

      common /erfs/ erftab(0:ntab,0:nterm), dtab, sqrtpi

      integer, save :: isave = 0

!-----------------------------------------------------------------------
!     /*   initialize                                                 */
!-----------------------------------------------------------------------

      if ( isave .eq. 0 ) then

         dtab = 6.d0/dble(ntab)

         do i = 0, ntab
            xtab        = dble(i)*dtab
            erftab(i,0) = error_function(xtab)
            do j = 1, nterm
               erftab(i,j) = gerf(xtab,j)
            end do
         end do

         pi     = acos(-1.d0)
         sqrtpi = sqrt(pi)

         isave = 1

      end if

!-----------------------------------------------------------------------

      if ( x .eq. 0.d0 ) then

         erf_1 = 2.d0/sqrtpi
         return

      end if

      ax   = abs(x)
      i    = nint(ax/dtab)
      xtab = dble(i)*dtab

      if ( xtab .ge. 6.d0 ) then

         erf_1 = 0.d0
         return

      else

         dx  = ax - xtab

!         coeff = 1.d0
!         erf_1 =  erftab(i,1)
!         do j = 1, nterm
!            coeff = coeff*dx/dble(j)
!            erf_1 = erf_1 + coeff*erftab(i,j+1)
!         end do

         erf_1 =  erftab(i,1) &
     &         + dx*(                        erftab(i,2) &
     &         + dx*0.5000000000000000d+00*( erftab(i,3) &
     &         + dx*0.3333333333333333d+00*( erftab(i,4) &
     &         + dx*0.2500000000000000d+00*( erftab(i,5) ))))

         return

      end if

      return
      end





!***********************************************************************
      real(8) function gerf(x,n)
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer :: j, k, n

      real(8) :: pi, x

      integer, parameter :: nmax = 8

      real(8):: error_function

      integer, save :: isave = 0

      real(8), save :: sqrtpi

      integer, save :: l(nmax,nmax)

!-----------------------------------------------------------------------
!     /*   initialize                                                 */
!-----------------------------------------------------------------------

      if ( isave .eq. 0 ) then

         do j = 1, nmax
         do k = 1, nmax
            l(k,j) =  0
         end do
         end do

         l(1,1) =  1
         l(2,1) =  0
         l(2,2) = -2

         do k = 3, nmax
            l(k,1) = l(k-1,2)
            do j = 2, k-1
               l(k,j) = j*l(k-1,j+1) - 2*l(k-1,j-1)
            end do
            l(k,k) = - 2*l(k-1,k-1)
         end do

         pi     = acos(-1.d0)
         sqrtpi = sqrt(pi)

         isave = 1

      end if

!-----------------------------------------------------------------------
!     /*   error function                                             */
!-----------------------------------------------------------------------

      gerf = 0.d0

      if ( n .eq. 0 ) then

         gerf = error_function(x)

      else if ( n .le. nmax ) then

         gerf = 2.d0/sqrtpi*l(n,1)*exp(-x*x)

         do j = 2, n
            gerf = gerf + 2.d0/sqrtpi*l(n,j)*x**(j-1)*exp(-x*x)
         end do

      end if

      return
      end

