!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Nov 10, 2018 by M. Shiga
!      Description:     Reading pimd code externally
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      program gau
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only: &
     &   x, y, z, fx, fy, fz, potential, dipx, dipy, dipz, &
     &   au_length, natom, nbead, iounit, pimd_command

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

!     /*   integers   */
      integer :: i, idummy, ierr

!     /*   real numbers   */
      real(8) :: xa, ya, za

!     /*   real parameters   */
      real(8), parameter :: bohr2ang = au_length/1.d-10

!     /*   characters   */
      character(len=80) :: char_1, char_2, char_3

!-----------------------------------------------------------------------
!     /*   arguments                                                  */
!-----------------------------------------------------------------------

      call getarg(1,char_1)
      call getarg(2,char_2)
      call getarg(3,char_3)

!-----------------------------------------------------------------------
!     /*   count number of atoms                                      */
!-----------------------------------------------------------------------

      open ( iounit, file = char_2 )

         read ( iounit, *, iostat=ierr )

         i = 0

         do

            read ( iounit, *, iostat=ierr ) idummy

            if ( ierr .ne. 0 ) exit

            i = i + 1

         end do

      close( iounit )

      natom = i

      nbead = 1

!-----------------------------------------------------------------------
!     /*   memory allocation                                          */
!-----------------------------------------------------------------------

      allocate( x(natom,nbead) )
      allocate( y(natom,nbead) )
      allocate( z(natom,nbead) )

      allocate( fx(natom,nbead) )
      allocate( fy(natom,nbead) )
      allocate( fz(natom,nbead) )

      allocate( dipx(nbead) )
      allocate( dipy(nbead) )
      allocate( dipz(nbead) )

!-----------------------------------------------------------------------
!     /*   read input file                                            */
!-----------------------------------------------------------------------

      open ( iounit, file = char_2 )

      read ( iounit, *, iostat=ierr )

      do i = 1, natom
         read ( iounit, *, iostat=ierr ) idummy, x(i,1), y(i,1), z(i,1)
      end do

      close( iounit )

!-----------------------------------------------------------------------
!     /*   convert into centroid.dat                                  */
!-----------------------------------------------------------------------

      open ( iounit, file = 'geometry.ini' )

      do i = 1, natom
         write( iounit, '(i2,3e24.16,3d10.2,3i2)' ) &
     &      1, x(i,1), y(i,1), z(i,1), 0.d0, 0.d0, 0.d0, 0, 0, 0
      end do

      close( iounit )

!-----------------------------------------------------------------------
!     /*   run pimd                                                   */
!-----------------------------------------------------------------------

      call system( trim(pimd_command) )

!-----------------------------------------------------------------------
!     /*   read energy and forces                                     */
!-----------------------------------------------------------------------

      open ( iounit, file = 'forces.out' )

      read ( iounit, * ) potential

      do i = 1, natom
         read ( iounit, * ) fx(i,1), fy(i,1), fz(i,1)
      end do

      close( iounit )

!-----------------------------------------------------------------------
!     /*   read dipole moment                                         */
!-----------------------------------------------------------------------

      open ( iounit, file = 'dipole.out' )

      read ( iounit, * ) idummy, dipx(1), dipy(1), dipz(1)

      close( iounit )

!-----------------------------------------------------------------------
!     /*   write energy and gradient                                  */
!-----------------------------------------------------------------------

      open ( iounit, file = char_3 )

      write( iounit, '(4d20.12)' ) &
     &   potential, dipx(1), dipy(1), dipz(1)

      do i = 1, natom
         write( iounit, '(3d20.12)' ) -fx(i,1), -fy(i,1), -fz(i,1)
      end do

      close( iounit )

!-----------------------------------------------------------------------
!     /*   trajectory                                                 */
!-----------------------------------------------------------------------

      open ( iounit, file = 'gau.xyz', access = 'append' )

      write( iounit, '(i8)' ) natom
      write( iounit, '(i8)' ) 1

      do i = 1, natom

         xa = x(i,1) * bohr2ang
         ya = y(i,1) * bohr2ang
         za = z(i,1) * bohr2ang

         write( iounit, '(a4,3f12.5)' ) 'X', xa, ya, za

      end do

      close( iounit )

      stop
      end

