!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Nov 10, 2018 by M. Shiga
!      Description:     energy and force from VASP calculation
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine force_vasp5_MPI
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   pot, fx, fy, fz, pot, x, y, z, vir, &
     &   nbead, natom, mbox, nprocs, myrank

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer          :: ibead, i, j

      character(len=3) :: char_num

      integer, save    :: iset = 0

      real(8)          :: xi, yi, zi

!-----------------------------------------------------------------------
!     /*   initialize                                                 */
!-----------------------------------------------------------------------

      if ( iset .eq. 0 ) then

         do ibead = 1, nbead

!           /*   allocated bead only   */
            if ( mod( ibead-1, nprocs ) .ne. myrank ) cycle

!           /*   character   */
            call int3_to_char( ibead, char_num )

!           /*   remove old directory and create new directory   */
            call system ('mkdir -p ./' // char_num )

!           /*   copy data files   */
            call system ('cp -f input.dat          ./' // char_num )
            call system ('cp -f input_default.dat  ./' // char_num )
            call system ('cp -f poscar.dat         ./' // char_num )
            call system ('cp -f INCAR              ./' // char_num )
            call system ('cp -f KPOINTS            ./' // char_num )
            call system ('cp -f POTCAR             ./' // char_num )

         end do

         iset = 1

      end if

!-----------------------------------------------------------------------
!        /*   make input                                              */
!-----------------------------------------------------------------------

      do ibead = 1, nbead

!        /*   allocated bead only   */
         if ( mod( ibead-1, nprocs ) .ne. myrank ) cycle

!        /*   character   */
         call int3_to_char( ibead, char_num )

!        /*   make input   */
         call iovasp_MPI ( 1, ibead, char_num )

!        /*   run vasp   */
         call system ( 'cd ' // char_num // &
     &                 '; run_vasp.x > output.vasp ; cd ..' )

!        /*   read output   */
         call iovasp_MPI ( 2, ibead, char_num )

      end do

!-----------------------------------------------------------------------
!     /*   all-reduce communication                                   */
!-----------------------------------------------------------------------

!     /*   potential   */
      call my_mpi_allreduce_real_1 ( pot, nbead )

!     /*   force   */
      call my_mpi_allreduce_real_2 ( fx, natom, nbead )
      call my_mpi_allreduce_real_2 ( fy, natom, nbead )
      call my_mpi_allreduce_real_2 ( fz, natom, nbead )

!-----------------------------------------------------------------------
!     /*   virial                                                     */
!-----------------------------------------------------------------------

      do j = 1, nbead
      do i = 1, natom

         xi = x(i,j)
         yi = y(i,j)
         zi = z(i,j)

         call pbc_unfold_MPI &
     &     ( xi, yi, zi, mbox(1,i,j), mbox(2,i,j), mbox(3,i,j) )

         vir(1,1) = vir(1,1) + fx(i,j)*xi
         vir(1,2) = vir(1,2) + fx(i,j)*yi
         vir(1,3) = vir(1,3) + fx(i,j)*zi
         vir(2,1) = vir(2,1) + fy(i,j)*xi
         vir(2,2) = vir(2,2) + fy(i,j)*yi
         vir(2,3) = vir(2,3) + fy(i,j)*zi
         vir(3,1) = vir(3,1) + fz(i,j)*xi
         vir(3,2) = vir(3,2) + fz(i,j)*yi
         vir(3,3) = vir(3,3) + fz(i,j)*zi

      end do
      end do

      return
      end





!***********************************************************************
      subroutine iovasp_MPI ( ioption, ibead, char_num )
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   x, y, z, fx, fy, fz, pot, natom, iounit

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer          :: i, ibead, ioption, ierr

      character(len=3) :: char_num

!-----------------------------------------------------------------------
!     /*   start                                                      */
!-----------------------------------------------------------------------

      ierr = 0

      if ( ioption .eq. 1 ) then

         open ( iounit, file = char_num // '/geometry.ini' )

         do i = 1, natom
            write( iounit, '(i8,6e24.16,3i4)' ) &
     &         1, x(i,ibead), y(i,ibead), z(i,ibead), &
     &         0.d0, 0.d0, 0.d0, 0, 0, 0
         end do

         close ( iounit )

      else if ( ioption .eq. 2 ) then

         open ( iounit, file = char_num // '/results.vasp' )

!        /*   potential   */

         read( iounit, *, iostat=ierr ) pot(ibead)

!        /*   gradient   */

         do i = 1, natom
            read( iounit, *, iostat=ierr ) &
     &         fx(i,ibead), fy(i,ibead), fz(i,ibead)
         end do

!        /*   gradient -> force  */
         do i = 1, natom
            fx(i,ibead) = - fx(i,ibead)
            fy(i,ibead) = - fy(i,ibead)
            fz(i,ibead) = - fz(i,ibead)
         end do

         close ( iounit )

      end if

      return
      end

