!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Nov 10, 2018 by M. Shiga
!      Description:     energy and force from ORCA calculation
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine force_orca
!***********************************************************************
!=======================================================================
!
!     WARNING:  DIPOLE MOMENT IS NOT READ.
!
!=======================================================================

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   x, y, z, fx, fy, fz, pot, dipx, dipy, dipz, vir, &
     &   orca_command, mbox, iounit, iounit_orca, nbead, natom

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer :: ierr, ibead, i, j, match, itest

      real(8) :: xi, yi, zi

      character(len=80):: char_line, char_symbol

      integer, save :: iset = 0

!-----------------------------------------------------------------------
!     /*   initialize                                                 */
!-----------------------------------------------------------------------

      ierr = 0

      if ( iset .eq. 0 ) then

!        /*   file open   */
         open ( iounit, file = 'input.dat' )

!        /*   search for tag    */
         call search_tag ( '<orca_command>', 14, iounit, ierr )

!        /*   read a line   */
         read ( iounit, *, iostat=ierr ) orca_command

!        /*   file close   */
         close ( iounit )

         if ( ierr .ne. 0 ) then

!           /*   file open   */
            open ( iounit, file = 'input_default.dat' )

!           /*   search for tag    */
            call search_tag ( '<orca_command>', 14, iounit, ierr )

!           /*   read a line   */
            read ( iounit, *, iostat=ierr ) orca_command

!           /*   file close   */
            close ( iounit )

         end if

!-----------------------------------------------------------------------
!        /*   confirm orca command                                    */
!-----------------------------------------------------------------------

         itest = 1

         if ( itest .eq. 0 ) then

            ierr = 1

            write( 6, '(a)' ) 'Error - orca command not found: ' // &
     &                         trim(orca_command)
            write( 6, '(a)' )

         else

            ierr = 0

            write( 6, '(a)' ) 'ORCA command found: ' // &
     &                         trim(orca_command)
            write( 6, '(a)' )

         end if

         call error_handling ( ierr, 'subroutine force_orca', 21 )

         iset = 1

      end if

!-----------------------------------------------------------------------
!     /*   start loop of beads                                        */
!-----------------------------------------------------------------------

      do ibead = 1, nbead

!-----------------------------------------------------------------------
!     /*   make orca input:  input.orca                               */
!-----------------------------------------------------------------------

!     /*   open the orca prototype file   */
      open ( iounit,     file = 'orca.dat'   )

!     /*   open the orca input file   */
      open ( iounit_orca, file = 'orca_scr.inp' )

!     /*   do loop end   */
      do

!        /*   read a line   */
         read ( iounit, '(a80)', iostat=ierr ) char_line

!        /*   exit at the end of the line   */
         if ( ierr .ne. 0 ) exit

         if ( char_line(1:4) .eq. '*xyz' ) then

!           /*   write a copy of the line   */
            write( iounit_orca, '(a)' ) char_line

            do i = 1, natom

!              /*   read atomic number   */
               read ( iounit, * ) char_symbol

               xi = x(i,ibead)
               yi = y(i,ibead)
               zi = z(i,ibead)

               call pbc_unfold &
     &            ( xi, yi, zi, mbox(1,i,ibead), mbox(2,i,ibead), &
     &              mbox(3,i,ibead) )

               write( iounit_orca, '(a3,3e24.16)' ) &
     &            char_symbol, xi, yi, zi

            end do

!        /*   if not matched   */
         else

!           /*   write a copy of the line   */
            write( iounit_orca, '(a)' ) char_line

         end if

!     /*   do loop end   */
      end do

!     /*   close files   */
      close(iounit)
      close(iounit_orca)

!-----------------------------------------------------------------------
!     /*   run orca                                                   */
!-----------------------------------------------------------------------

      call system ( orca_command // ' orca_scr.inp > orca_scr.out' )

!-----------------------------------------------------------------------
!     /*   read orca output:  potential                               */
!-----------------------------------------------------------------------

!     /*   open the orca output file   */
      open ( iounit, file = 'orca_scr.engrad' )

!     /*   do loop start   */
      do

!        /*   read a line   */
         read ( iounit, '(a80)', iostat=ierr ) char_line

!        /*   see if the line matches   */
         match = index( char_line(1:26), '# The current total energy' )

!        /*   if matched   */
         if ( match .ge. 1 ) then

!           /*   read a line   */
            read ( iounit, *, iostat=ierr )

!           /*   read a line   */
            read ( iounit, *, iostat=ierr ) pot(ibead)

!           /*   exit from the do loop   */
            exit

         end if

!     /*   do loop end   */
      end do

!     /*   close file   */
      close(iounit)

!-----------------------------------------------------------------------
!     /*   read orca output:  potential gradient                      */
!-----------------------------------------------------------------------

!     /*   open the orca output file   */
      open ( iounit, file = 'orca_scr.engrad' )

!     /*   do loop start   */
      do

!        /*   read a line   */
         read ( iounit, '(a80)', iostat=ierr ) char_line

!        /*   see if the line matches   */
         match = index( char_line(1:22), '# The current gradient' )

!        /*   if matched   */
         if ( match .ge. 1 ) then

!           /*   read a line   */
            read ( iounit, *, iostat=ierr )

!           /*   read potential gradient data   */

            do i = 1, natom
               read ( iounit, * ) fx(i,ibead)
               read ( iounit, * ) fy(i,ibead)
               read ( iounit, * ) fz(i,ibead)
            end do

!           /*   change sign:  gradient -> force   */

            do i = 1, natom
               fx(i,ibead) = - fx(i,ibead)
               fy(i,ibead) = - fy(i,ibead)
               fz(i,ibead) = - fz(i,ibead)
            end do

!           /*   exit from the do loop   */
            exit

         end if

!     /*   do loop end   */
      end do

!     /*   close file   */
      close(iounit)

!-----------------------------------------------------------------------
!     /*   read orca output:  dipole moment                           */
!-----------------------------------------------------------------------

!     /*   WARNING: all zero   */

      dipx(ibead) = 0.d0
      dipy(ibead) = 0.d0
      dipz(ibead) = 0.d0

!-----------------------------------------------------------------------
!     /*   end loop of beads                                          */
!-----------------------------------------------------------------------

      end do

!-----------------------------------------------------------------------
!     /*   virial                                                     */
!-----------------------------------------------------------------------

      do j = 1, nbead
      do i = 1, natom

         xi = x(i,j)
         yi = y(i,j)
         zi = z(i,j)

         call pbc_unfold &
     &     ( xi, yi, zi, mbox(1,i,j), mbox(2,i,j), mbox(3,i,j) )

         vir(1,1) = vir(1,1) + fx(i,j)*xi
         vir(1,2) = vir(1,2) + fx(i,j)*yi
         vir(1,3) = vir(1,3) + fx(i,j)*zi
         vir(2,1) = vir(2,1) + fy(i,j)*xi
         vir(2,2) = vir(2,2) + fy(i,j)*yi
         vir(2,3) = vir(2,3) + fy(i,j)*zi
         vir(3,1) = vir(3,1) + fz(i,j)*xi
         vir(3,2) = vir(3,2) + fz(i,j)*yi
         vir(3,3) = vir(3,3) + fz(i,j)*zi

      end do
      end do

      return
      end

