!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Dec 3, 2019 by M. Shiga
!      Description:     Muller-Brown potential
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine force_muller_MPI
!***********************************************************************

      use common_variables, only : &
     &   x, y, fx, fy, pot, natom, nbead, myrank, nprocs

      implicit none

      real(8) :: x0(4), y0(4), a(4), b(4), c(4), d(4)

      real(8) :: axx, bxy, cyy, ax, bx, by, cy, de

      integer :: i, j, k

      x0(1) =   1.0d0
      x0(2) =   0.0d0
      x0(3) =  -0.5d0
      x0(4) =  -1.0d0

      y0(1) =   0.0d0
      y0(2) =   0.5d0
      y0(3) =   1.5d0
      y0(4) =   1.0d0

      a(1) =   -1.0d0
      a(2) =   -1.0d0
      a(3) =   -6.5d0
      a(4) =    0.7d0

      b(1) =    0.0d0
      b(2) =    0.0d0
      b(3) =   11.0d0
      b(4) =    0.6d0

      c(1) =  -10.0d0
      c(2) =  -10.0d0
      c(3) =   -6.5d0
      c(4) =    0.7d0

      d(1) = -200.0d0 / 10000.d0
      d(2) = -100.0d0 / 10000.d0
      d(3) = -170.0d0 / 10000.d0
      d(4) =   15.0d0 / 10000.d0

      do j = 1, nbead

         if ( mod( j-1, nprocs ) .ne. myrank ) cycle

         do i = 1, natom

            do k = 1, 4

               axx = a(k) * ( x(i,j) - x0(k) ) * ( x(i,j) - x0(k) )
               bxy = b(k) * ( x(i,j) - x0(k) ) * ( y(i,j) - y0(k) )
               cyy = c(k) * ( y(i,j) - y0(k) ) * ( y(i,j) - y0(k) )

               ax  = a(k) * ( x(i,j) - x0(k) )
               bx  = b(k) * ( x(i,j) - x0(k) )
               by  = b(k) * ( y(i,j) - y0(k) )
               cy  = c(k) * ( y(i,j) - y0(k) )

               de  = d(k) * exp( axx + bxy + cyy )

               pot(j) = pot(j) + de

               fx(i,j) = fx(i,j) - de * ( 2.d0*ax + by )
               fy(i,j) = fy(i,j) - de * ( 2.d0*cy + bx )

            end do

         end do

      end do

!-----------------------------------------------------------------------
!     /*   all-reduce communication                                   */
!-----------------------------------------------------------------------

!     /*   potential   */
      call my_mpi_allreduce_real_1 ( pot, nbead )

!     /*   force   */
      call my_mpi_allreduce_real_2 ( fx, natom, nbead )
      call my_mpi_allreduce_real_2 ( fy, natom, nbead )

      return
      end
