!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Nov 25, 2018 by M. Shiga
!      Description:     energy and force from lennard-jones pair
!
!///////////////////////////////////////////////////////////////////////



#ifndef nextver



!***********************************************************************
      subroutine force_mm_ljpair
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   x, y, z, fx, fy, fz, pot, vir, boxinv, box, &
     &   iboundary, natom, nbead

      use mm_variables, only : &
     &   rout_ljpair, rin_ljpair, eps_ljpair, sig_ljpair, bigboxinv, &
     &   bigbox, nbox_ljpair, nljpair, epsrule_ljpair, sigrule_ljpair

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer :: i, j, m, jx, jy, jz, j2

      real(8) :: rout_ljpair2, xij, yij, zij, rij2, rij, rinv, eps, sig, &
     &           sr, sr2, sr6, sr12, u6, u12, uij, duij, fxi, fyi, fzi, &
     &           swf, dswf, aij, bij, cij, absa, absb, absc

!-----------------------------------------------------------------------
!     /*   initialize                                                 */
!-----------------------------------------------------------------------

      if ( nljpair .eq. 0 ) return

      rout_ljpair2 = rout_ljpair*rout_ljpair

!-----------------------------------------------------------------------
!     /*   extention of simulation box in real space sum              */
!-----------------------------------------------------------------------

      if ( ( iboundary .eq. 1 ) .or. ( iboundary .eq. 2 ) ) then

         absa = sqrt ( boxinv(1,1)*boxinv(1,1) &
     &               + boxinv(1,2)*boxinv(1,2) &
     &               + boxinv(1,3)*boxinv(1,3) )
         absb = sqrt ( boxinv(2,1)*boxinv(2,1) &
     &               + boxinv(2,2)*boxinv(2,2) &
     &               + boxinv(2,3)*boxinv(2,3) )
         absc = sqrt ( boxinv(3,1)*boxinv(3,1) &
     &               + boxinv(3,2)*boxinv(3,2) &
     &               + boxinv(3,3)*boxinv(3,3) )

         nbox_ljpair(1) = int(2.d0*rout_ljpair*absa) + 1
         nbox_ljpair(2) = int(2.d0*rout_ljpair*absb) + 1
         nbox_ljpair(3) = int(2.d0*rout_ljpair*absc) + 1

      end if

!-----------------------------------------------------------------------
!     /*   main loop : free boundary                                  */
!-----------------------------------------------------------------------

      if ( iboundary .eq. 0 ) then

         do m = 1, nbead

         do i = 1, natom-1
         do j = i+1, natom

            xij = x(i,m) - x(j,m)
            yij = y(i,m) - y(j,m)
            zij = z(i,m) - z(j,m)

            call pbc_atom ( xij, yij, zij )

            rij2 = xij*xij + yij*yij + zij*zij

            if ( rij2 .gt. rout_ljpair2 ) cycle

            rij     = sqrt(rij2)

            rinv    = 1.d0/rij

            call get_eps_ljpair &
     &         ( eps_ljpair(i), eps_ljpair(j), eps, epsrule_ljpair )

            call get_sig_ljpair &
     &         ( sig_ljpair(i), sig_ljpair(j), sig, sigrule_ljpair )

            sr      = sig*rinv
            sr2     = sr*sr
            sr6     = sr2*sr2*sr2
            sr12    = sr6*sr6

            u6      = - 4.d0*eps*sr6
            u12     = + 4.d0*eps*sr12

!           /*   switching function   */
            call getswf( rij, rin_ljpair, rout_ljpair, swf, dswf )

!           /*   bare potential   */
            uij     = + u6 + u12

!           /*   bare potential gradient   */
            duij    = ( - 6.d0*u6*rinv - 12.d0*u12*rinv )*swf

!           /*   corrected potential   */
            pot(m)  = pot(m) + uij*swf

!           /*   corrected forces   */

            fxi = - uij*dswf*xij*rinv - duij*xij*rinv
            fyi = - uij*dswf*yij*rinv - duij*yij*rinv
            fzi = - uij*dswf*zij*rinv - duij*zij*rinv

            fx(i,m) = fx(i,m) + fxi
            fy(i,m) = fy(i,m) + fyi
            fz(i,m) = fz(i,m) + fzi

            fx(j,m) = fx(j,m) - fxi
            fy(j,m) = fy(j,m) - fyi
            fz(j,m) = fz(j,m) - fzi

            vir(1,1) = vir(1,1) + fxi*xij
            vir(1,2) = vir(1,2) + fxi*yij
            vir(1,3) = vir(1,3) + fxi*zij
            vir(2,1) = vir(2,1) + fyi*xij
            vir(2,2) = vir(2,2) + fyi*yij
            vir(2,3) = vir(2,3) + fyi*zij
            vir(3,1) = vir(3,1) + fzi*xij
            vir(3,2) = vir(3,2) + fzi*yij
            vir(3,3) = vir(3,3) + fzi*zij

         end do
         end do

         end do

!-----------------------------------------------------------------------
!     /*   main loop : periodic boundary with minimum image           */
!-----------------------------------------------------------------------

      else if(nbox_ljpair(1)*nbox_ljpair(2)*nbox_ljpair(3) .eq. 1) then

         do m = 1, nbead

         do i = 1, natom-1
         do j = i+1, natom

            xij = x(i,m) - x(j,m)
            yij = y(i,m) - y(j,m)
            zij = z(i,m) - z(j,m)

            call pbc_atom ( xij, yij, zij )

            rij2 = xij*xij + yij*yij + zij*zij

            if ( rij2 .gt. rout_ljpair2 ) cycle

            rij     = sqrt(rij2)

            rinv    = 1.d0/rij

            call get_eps_ljpair &
     &         ( eps_ljpair(i), eps_ljpair(j), eps, epsrule_ljpair )

            call get_sig_ljpair &
     &         ( sig_ljpair(i), sig_ljpair(j), sig, sigrule_ljpair )

            sr      = sig*rinv
            sr2     = sr*sr
            sr6     = sr2*sr2*sr2
            sr12    = sr6*sr6

            u6      = - 4.d0*eps*sr6
            u12     = + 4.d0*eps*sr12

!           /*   switching function   */
            call getswf( rij, rin_ljpair, rout_ljpair, swf, dswf )

!           /*   bare potential   */
            uij     = + u6 + u12

!           /*   bare potential gradient   */
            duij    = ( - 6.d0*u6*rinv - 12.d0*u12*rinv )*swf

!           /*   corrected potential   */
            pot(m)  = pot(m) + uij*swf

!           /*   corrected forces   */

            fxi = - uij*dswf*xij*rinv - duij*xij*rinv
            fyi = - uij*dswf*yij*rinv - duij*yij*rinv
            fzi = - uij*dswf*zij*rinv - duij*zij*rinv

            fx(i,m) = fx(i,m) + fxi
            fy(i,m) = fy(i,m) + fyi
            fz(i,m) = fz(i,m) + fzi

            fx(j,m) = fx(j,m) - fxi
            fy(j,m) = fy(j,m) - fyi
            fz(j,m) = fz(j,m) - fzi

            vir(1,1) = vir(1,1) + fxi*xij
            vir(1,2) = vir(1,2) + fxi*yij
            vir(1,3) = vir(1,3) + fxi*zij
            vir(2,1) = vir(2,1) + fyi*xij
            vir(2,2) = vir(2,2) + fyi*yij
            vir(2,3) = vir(2,3) + fyi*zij
            vir(3,1) = vir(3,1) + fzi*xij
            vir(3,2) = vir(3,2) + fzi*yij
            vir(3,3) = vir(3,3) + fzi*zij

         end do
         end do

         end do

!-----------------------------------------------------------------------
!     /*   main loop : periodic boundary                              */
!-----------------------------------------------------------------------

      else

         bigbox(:,1) = dble(nbox_ljpair(1))*box(:,1)
         bigbox(:,2) = dble(nbox_ljpair(2))*box(:,2)
         bigbox(:,3) = dble(nbox_ljpair(3))*box(:,3)

         call inv3 ( bigbox, bigboxinv )

         do m = 1, nbead

         do i = 1, natom
         do j = i, natom

            do jx = 0, nbox_ljpair(1)-1
            do jy = 0, nbox_ljpair(2)-1
            do jz = 0, nbox_ljpair(3)-1

               j2 = jx*jx + jy*jy + jz*jz

               if ( ( j2 .eq. 0 ) .and. ( i .eq. j ) ) cycle

               xij = x(i,m) - x(j,m)
               yij = y(i,m) - y(j,m)
               zij = z(i,m) - z(j,m)

               xij = xij - box(1,1)*jx - box(1,2)*jy - box(1,3)*jz
               yij = yij - box(2,1)*jx - box(2,2)*jy - box(2,3)*jz
               zij = zij - box(3,1)*jx - box(3,2)*jy - box(3,3)*jz

               aij = bigboxinv(1,1)*xij + bigboxinv(1,2)*yij &
     &             + bigboxinv(1,3)*zij
               bij = bigboxinv(2,1)*xij + bigboxinv(2,2)*yij &
     &             + bigboxinv(2,3)*zij
               cij = bigboxinv(3,1)*xij + bigboxinv(3,2)*yij &
     &             + bigboxinv(3,3)*zij

               aij = aij - nint(aij)
               bij = bij - nint(bij)
               cij = cij - nint(cij)

               xij = bigbox(1,1)*aij + bigbox(1,2)*bij + bigbox(1,3)*cij
               yij = bigbox(2,1)*aij + bigbox(2,2)*bij + bigbox(2,3)*cij
               zij = bigbox(3,1)*aij + bigbox(3,2)*bij + bigbox(3,3)*cij

               rij2 = xij*xij + yij*yij + zij*zij

               if ( rij2 .gt. rout_ljpair2 ) cycle

               rij     = sqrt(rij2)

               rinv    = 1.d0/rij

               call get_eps_ljpair &
     &            ( eps_ljpair(i), eps_ljpair(j), eps, epsrule_ljpair )

               call get_sig_ljpair &
     &            ( sig_ljpair(i), sig_ljpair(j), sig, sigrule_ljpair )

               sr      = sig*rinv
               sr2     = sr*sr
               sr6     = sr2*sr2*sr2
               sr12    = sr6*sr6

               u6      = - 4.d0*eps*sr6
               u12     = + 4.d0*eps*sr12

!              /*   switching function   */
               call getswf( rij, rin_ljpair, rout_ljpair, swf, dswf )

!              /*   bare potential   */
               uij     = + u6 + u12

!              /*   bare potential gradient   */
               duij    = ( - 6.d0*u6*rinv - 12.d0*u12*rinv )*swf

!              /*   corrected potential   */
               pot(m)  = pot(m) + uij*swf*0.5d0

!              /*   corrected forces   */

               fxi = - uij*dswf*xij*rinv - duij*xij*rinv
               fyi = - uij*dswf*yij*rinv - duij*yij*rinv
               fzi = - uij*dswf*zij*rinv - duij*zij*rinv

               fx(i,m) = fx(i,m) + 0.5d0*fxi
               fy(i,m) = fy(i,m) + 0.5d0*fyi
               fz(i,m) = fz(i,m) + 0.5d0*fzi

               fx(j,m) = fx(j,m) - 0.5d0*fxi
               fy(j,m) = fy(j,m) - 0.5d0*fyi
               fz(j,m) = fz(j,m) - 0.5d0*fzi

               vir(1,1) = vir(1,1) + 0.5d0*fxi*xij
               vir(1,2) = vir(1,2) + 0.5d0*fxi*yij
               vir(1,3) = vir(1,3) + 0.5d0*fxi*zij
               vir(2,1) = vir(2,1) + 0.5d0*fyi*xij
               vir(2,2) = vir(2,2) + 0.5d0*fyi*yij
               vir(2,3) = vir(2,3) + 0.5d0*fyi*zij
               vir(3,1) = vir(3,1) + 0.5d0*fzi*xij
               vir(3,2) = vir(3,2) + 0.5d0*fzi*yij
               vir(3,3) = vir(3,3) + 0.5d0*fzi*zij

            end do
            end do
            end do

            if ( i .eq. j ) cycle

            do jx = 0, nbox_ljpair(1)-1
            do jy = 0, nbox_ljpair(2)-1
            do jz = 0, nbox_ljpair(3)-1

               j2 = jx*jx + jy*jy + jz*jz

               if ( ( j2 .eq. 0 ) .and. ( i .eq. j ) ) cycle

               xij = x(j,m) - x(i,m)
               yij = y(j,m) - y(i,m)
               zij = z(j,m) - z(i,m)

               xij = xij - box(1,1)*jx - box(1,2)*jy - box(1,3)*jz
               yij = yij - box(2,1)*jx - box(2,2)*jy - box(2,3)*jz
               zij = zij - box(3,1)*jx - box(3,2)*jy - box(3,3)*jz

               aij = bigboxinv(1,1)*xij + bigboxinv(1,2)*yij &
     &             + bigboxinv(1,3)*zij
               bij = bigboxinv(2,1)*xij + bigboxinv(2,2)*yij &
     &             + bigboxinv(2,3)*zij
               cij = bigboxinv(3,1)*xij + bigboxinv(3,2)*yij &
     &             + bigboxinv(3,3)*zij

               aij = aij - nint(aij)
               bij = bij - nint(bij)
               cij = cij - nint(cij)

               xij = bigbox(1,1)*aij + bigbox(1,2)*bij + bigbox(1,3)*cij
               yij = bigbox(2,1)*aij + bigbox(2,2)*bij + bigbox(2,3)*cij
               zij = bigbox(3,1)*aij + bigbox(3,2)*bij + bigbox(3,3)*cij

               rij2 = xij*xij + yij*yij + zij*zij

               if ( rij2 .gt. rout_ljpair2 ) cycle

               rij     = sqrt(rij2)

               rinv    = 1.d0/rij

               call get_eps_ljpair &
     &            ( eps_ljpair(j), eps_ljpair(i), eps, epsrule_ljpair )

               call get_sig_ljpair &
     &            ( sig_ljpair(j), sig_ljpair(i), sig, sigrule_ljpair )

               sr      = sig*rinv
               sr2     = sr*sr
               sr6     = sr2*sr2*sr2
               sr12    = sr6*sr6

               u6      = - 4.d0*eps*sr6
               u12     = + 4.d0*eps*sr12

!              /*   switching function   */
               call getswf( rij, rin_ljpair, rout_ljpair, swf, dswf )

!              /*   bare potential   */
               uij     = + u6 + u12

!              /*   bare potential gradient   */
               duij    = ( - 6.d0*u6*rinv - 12.d0*u12*rinv )*swf

!              /*   corrected potential   */
               pot(m)  = pot(m) + uij*swf*0.5d0

!              /*   corrected forces   */

               fxi = - uij*dswf*xij*rinv - duij*xij*rinv
               fyi = - uij*dswf*yij*rinv - duij*yij*rinv
               fzi = - uij*dswf*zij*rinv - duij*zij*rinv

               fx(j,m) = fx(j,m) + 0.5d0*fxi
               fy(j,m) = fy(j,m) + 0.5d0*fyi
               fz(j,m) = fz(j,m) + 0.5d0*fzi

               fx(i,m) = fx(i,m) - 0.5d0*fxi
               fy(i,m) = fy(i,m) - 0.5d0*fyi
               fz(i,m) = fz(i,m) - 0.5d0*fzi

               vir(1,1) = vir(1,1) + 0.5d0*fxi*xij
               vir(1,2) = vir(1,2) + 0.5d0*fxi*yij
               vir(1,3) = vir(1,3) + 0.5d0*fxi*zij
               vir(2,1) = vir(2,1) + 0.5d0*fyi*xij
               vir(2,2) = vir(2,2) + 0.5d0*fyi*yij
               vir(2,3) = vir(2,3) + 0.5d0*fyi*zij
               vir(3,1) = vir(3,1) + 0.5d0*fzi*xij
               vir(3,2) = vir(3,2) + 0.5d0*fzi*yij
               vir(3,3) = vir(3,3) + 0.5d0*fzi*zij

            end do
            end do
            end do

         end do
         end do

         end do

      end if

      return
      end





!***********************************************************************
      subroutine force_mm_ljpair_setup
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   natom, iounit

      use mm_variables, only : &
     &   eps_ljpair, sig_ljpair, rin_ljpair, rout_ljpair, &
     &   epsrule_ljpair, sigrule_ljpair, nljpair

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer :: k, l, ierr

!-----------------------------------------------------------------------
!     /*   set up                                                     */
!-----------------------------------------------------------------------

      open (iounit,file = 'mm.dat')

!        /*   tag   */
         call search_tag ( '<ljpair>', 8, iounit, ierr )

!        /*   combination rules of lennard-jones pair interaction   */
         if ( ierr .eq. 0 ) then
            read( iounit, *, iostat=ierr ) &
     &         epsrule_ljpair, sigrule_ljpair
         end if

      close(iounit)

      if ( ierr .ne. 0 ) then
         epsrule_ljpair = 'DEFAULT'
         sigrule_ljpair = 'DEFAULT'
         nljpair = 0
         return
      else
         nljpair = natom
         if ( .not. allocated(eps_ljpair ) ) &
     &      allocate(eps_ljpair(natom))
         if ( .not. allocated(sig_ljpair ) ) &
     &      allocate(sig_ljpair(natom))
         eps_ljpair(:) = 0.d0
         sig_ljpair(:) = 1.d0
      end if

      open (iounit, file = 'mm.dat')

!        /*   tag   */
         call search_tag ( '<ljpair>', 8, iounit, ierr )

!        /*   number of lennard-jones interaction   */
         read( iounit, *, iostat=ierr )

!        /*   cut off distance, inside and outside   */
         read( iounit, *, iostat=ierr ) rin_ljpair, rout_ljpair

!        /*   atom 1, atom 2, epsilon, sigma   */
         do l = 1, natom
            read( iounit, *, iostat=ierr ) &
     &         k, eps_ljpair(k), sig_ljpair(k)
         end do

      close(iounit)

      return
      end



#endif
