!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Nov 10, 2018 by M. Shiga
!      Description:     energy and force from Gaussian 98 calculation
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine force_g98
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   x, y, z, fx, fy, fz, pot, dipx, dipy, dipz, vir, &
     &   g98_exe_command, g98_formchk_command, iexe_grad_g98, mbox, &
     &   iexe_dip_g98, iounit, iounit_g98, nbead, natom

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer :: ierr, ibead, iblank, i, j, ian, match, nline, itest

      real(8) :: xi, yi, zi

      character(len=128):: char_line, char_command

      integer, save :: iset = 0

!-----------------------------------------------------------------------
!     /*   initialize                                                 */
!-----------------------------------------------------------------------

      ierr = 0

      if ( iset .eq. 0 ) then

!        /*   file open   */
         open ( iounit, file = 'input.dat' )

!        /*   search for tag    */
         call search_tag ( '<g98_command>', 13, iounit, ierr )

!        /*   read a line   */
         read ( iounit, *, iostat=ierr ) g98_exe_command

!        /*   read a line   */
         read ( iounit, *, iostat=ierr ) g98_formchk_command

!        /*   file close   */
         close ( iounit )

         if ( ierr .ne. 0 ) then

!           /*   file open   */
            open ( iounit, file = 'input_default.dat' )

!           /*   search for tag    */
            call search_tag ( '<g98_command>', 13, iounit, ierr )

!           /*   read a line
            read ( iounit, *, iostat=ierr ) g98_exe_command

!           /*   read a line
            read ( iounit, *, iostat=ierr ) g98_formchk_command

!           /*   file close   */
            close ( iounit )

         end if

!        /*   file open   */
         open ( iounit, file = 'input.dat' )

!        /*   search for tag    */
         call search_tag ( '<g98_grad>', 10, iounit, ierr )

!        /*   read a line   */
         read ( iounit, *, iostat=ierr ) iexe_grad_g98

!        /*   file close   */
         close ( iounit )

         if ( ierr .ne. 0 ) then

!           /*   file open   */
            open ( iounit, file = 'input_default.dat' )

!           /*   search for tag    */
            call search_tag ( '<g98_grad>', 10, iounit, ierr )

!           /*   read a line   */
            read ( iounit, *, iostat=ierr ) iexe_grad_g98

!           /*   file close   */
            close ( iounit )

         end if

!        /*   file open   */
         open ( iounit, file = 'input.dat' )

!        /*   search for tag    */
         call search_tag ( '<g98_dip>', 9, iounit, ierr )

!        /*   read a line   */
         read ( iounit, *, iostat=ierr ) iexe_dip_g98

!        /*   file close   */
         close ( iounit )

         if ( ierr .ne. 0 ) then

!           /*   file open   */
            open ( iounit, file = 'input_default.dat' )

!           /*   search for tag    */
            call search_tag ( '<g98_dip>', 9, iounit, ierr )

!           /*   read a line   */
            read ( iounit, *, iostat=ierr ) iexe_dip_g98

!           /*   file close   */
            close ( iounit )

         end if

!-----------------------------------------------------------------------
!        /*   confirm g98 command                                     */
!-----------------------------------------------------------------------

!         call system
!     &      ("echo '0' > test.out")
!         call system
!     &      ("which " // g98_exe_command //
!     &       " > /dev/null 2>&1 && echo '1' > test.out")
!         open ( iounit, file = 'test.out' )
!         read ( iounit, * ) itest
!         close( iounit )

         itest = 1

         if ( itest .eq. 0 ) then

            ierr = 1

            write( 6, '(a)' ) 'Error - G98 command not found: ' // &
     &                         trim(g98_exe_command)
            write( 6, '(a)' )

         else

            ierr = 0

            write( 6, '(a)' ) 'G98 command found: ' // &
     &                         trim(g98_exe_command)

         end if

         call system('rm -f test.out')

         call error_handling ( ierr, 'subroutine force_g03', 20 )

         iset = 1

      end if

!-----------------------------------------------------------------------
!     /*   start loop of beads                                        */
!-----------------------------------------------------------------------

      do ibead = 1, nbead

!-----------------------------------------------------------------------
!     /*   make g98 input:  input.g98                                 */
!-----------------------------------------------------------------------

!     /*   open the g98 prototype file   */
      open ( iounit,     file = 'g98.dat'   )

!     /*   open the g98 input file   */
      open ( iounit_g98, file = 'input.g98' )

      iblank = 0

!     /*   do loop end   */
      do

!        /*   read a line   */
         read ( iounit, '(a)', iostat=ierr ) char_line

!        /*   exit at the end of the line   */
         if ( ierr .ne. 0 ) exit

         if ( char_line(1:10) .eq. '          ' ) iblank = iblank + 1

!        /*   if two blanks have been found   */
         if ( iblank .eq. 2 ) then

!           /*   write a copy of the line   */
            write( iounit_g98, '(a)' ) char_line

!           /*   read a line   */
            read ( iounit, '(a)', iostat=ierr ) char_line

!           /*   write a copy of the line   */
            write( iounit_g98, '(a)' ) char_line

            do i = 1, natom

!              /*   read atomic number   */
               read ( iounit, * ) ian

!              /*   write atomic number and Cartesian coordinates   */
!               write( iounit_g98, '(i8,3e24.16)' )
!     &            ian, x(i,ibead), y(i,ibead), z(i,ibead)

                xi = x(i,ibead)
                yi = y(i,ibead)
                zi = z(i,ibead)

                call pbc_unfold &
     &             ( xi, yi, zi, mbox(1,i,ibead), mbox(2,i,ibead), &
     &               mbox(3,i,ibead) )

                write( iounit_g98, '(i8,3e24.16)' ) ian, xi, yi, zi

            end do

!        /*   if matched to check point file   */
         else if ( index(char_line(1:4),'%chk') .ge. 1 ) then

            write( iounit_g98, '(a)' ) '%chk=chk.g98'

!        /*   if not matched   */
         else

!           /*   write a copy of the line   */
            write( iounit_g98, '(a)' ) char_line

         end if

!     /*   do loop end   */
      end do

!     /*   add a blank line at the end   */
      write(iounit_g98,'(a)')

!     /*   close files   */
      close(iounit)
      close(iounit_g98)

!-----------------------------------------------------------------------
!     /*   run g98                                                    */
!-----------------------------------------------------------------------

!      char_command = '/appli_1/Gaussian/g98/g98'
      char_command = g98_exe_command

      call system ( char_command // ' < input.g98 > output.g98' )

!      char_command = '/appli_1/Gaussian/g98/formchk'
      char_command = g98_formchk_command

      call system ( char_command // ' chk.g98 fchk.g98 > log.g98' )

!-----------------------------------------------------------------------
!     /*   read g98 output:  potential                                */
!-----------------------------------------------------------------------

!     /*   open the g98 output file   */
      open ( iounit_g98, file = 'fchk.g98' )

!     /*   do loop start   */
      do

!        /*   read a line   */
         read ( iounit_g98, '(a)', iostat=ierr ) char_line

!        /*   error handling   */
         if ( ierr .ne. 0 ) then
            close(iounit_g98)
            call system('sleep 1')
            char_command = g98_formchk_command
            call system( char_command // ' chk.g98 fchk.g98 > log.g98' )
            call system('sleep 1')
            read ( iounit_g98, '(a)', iostat=ierr ) char_line
            call error_handling ( ierr, 'subroutine force_g98', 20 )
         end if

!        /*   see if the line matches   */
         match = index( char_line(1:12), 'Total Energy' )

!        /*   if matched   */
         if ( match .ge. 1 ) then

!           /*   write potential data to a scratch file   */
            open ( iounit, file ='scratch.g98' )
               write (iounit,'(a)') char_line(48:72)
            close( iounit )

!           /*   read the potential data   */
            open ( iounit, file ='scratch.g98' )
               read (iounit,*) pot(ibead)
            close( iounit )

!           /*   delete scratch file   */
            call system( 'rm -f scratch.g98' )

!           /*   exit from the do loop   */
            exit

         end if

!     /*   do loop end   */
      end do

!     /*   close file   */
      close(iounit_g98)

!-----------------------------------------------------------------------
!     /*   read g98 output:  potential gradient                       */
!-----------------------------------------------------------------------

      if ( iexe_grad_g98 .eq. 0 ) then

         do i = 1, natom
            fx(i,ibead) = 0.d0
            fy(i,ibead) = 0.d0
            fz(i,ibead) = 0.d0
         end do

      else

!        /*   open the g98 output file   */
         open ( iounit_g98, file = 'fchk.g98' )

!        /*   do loop start   */
         do

!        /*   read a line   */
         read ( iounit_g98, '(a)', iostat=ierr ) char_line

!        /*   error handling   */
         call error_handling ( ierr, 'subroutine force_g98', 20 )

!        /*   see if the line matches   */
         match = index( char_line(1:18), 'Cartesian Gradient' )

!        /*   if matched   */
         if ( match .ge. 1 ) then

!           /*   open scratch file   */
            open ( iounit, file = 'scratch.g98' )

!           /*   count number of lines need to be read   */

            if ( mod(natom*3,5) .eq. 0 ) nline = (natom*3)/5
            if ( mod(natom*3,5) .ne. 0 ) nline = (natom*3)/5 + 1

            do i = 1, nline

!              /*   read potential gradient data from g98 output   */
               read ( iounit_g98, '(a)', iostat=ierr ) char_line

!              /*   error handling   */
               call error_handling ( ierr, 'subroutine force_g98', 20 )

!              /*    write potential gradient data to scratch file   */

               write (iounit,'(a)') char_line( 1:16)
               write (iounit,'(a)') char_line(17:32)
               write (iounit,'(a)') char_line(33:48)
               write (iounit,'(a)') char_line(49:64)
               write (iounit,'(a)') char_line(65:80)

            end do

!           /*   close scratch file   */
            close(iounit)

!           /*   open scratch file   */
            open (iounit, file ='scratch.g98')

!              /*   read potential gradient data   */

               do i = 1, natom
                  read ( iounit, * ) fx(i,ibead)
                  read ( iounit, * ) fy(i,ibead)
                  read ( iounit, * ) fz(i,ibead)
               end do

!              /*   change sign:  gradient -> force   */

               do i = 1, natom
                  fx(i,ibead) = - fx(i,ibead)
                  fy(i,ibead) = - fy(i,ibead)
                  fz(i,ibead) = - fz(i,ibead)
               end do

            close(iounit)

!           /*   delete scratch file   */
            call system( 'rm -f scratch.g98' )

!           /*   exit from the do loop   */
            exit

         end if

!        /*  do loop end   */
         end do

!        /*   close file   */
         close( iounit_g98 )

      end if

!-----------------------------------------------------------------------
!     /*   read g98 output:  dipole moment                            */
!-----------------------------------------------------------------------

      if ( iexe_dip_g98 .eq. 0 ) then

         dipx(ibead) = 0.d0
         dipy(ibead) = 0.d0
         dipz(ibead) = 0.d0

      else

!        /*   open the g98 output file   */
         open ( iounit_g98, file = 'fchk.g98' )

!        /*   do loop start   */
         do

!        /*   read a line   */
         read ( iounit_g98, '(a)', iostat=ierr ) char_line

!        /*   error handling   */
         call error_handling ( ierr, 'subroutine force_g98', 20 )

!        /*   see if the line matches   */
         match = index( char_line(1:13), 'Dipole Moment' )

!        /*   if matched   */
         if ( match .ge. 1 ) then

!           /*   read dipole moment data   */
            read( iounit_g98, * ) dipx(ibead), dipy(ibead), dipz(ibead)

!           /*   exit from the do loop   */
            exit

         end if

!        /*   do loop end   */
         end do

!        /*   close file   */
         close( iounit_g98 )

      end if

!-----------------------------------------------------------------------
!     /*   end loop of beads                                          */
!-----------------------------------------------------------------------

      end do

!-----------------------------------------------------------------------
!     /*   virial                                                     */
!-----------------------------------------------------------------------

      do j = 1, nbead
      do i = 1, natom

         xi = x(i,j)
         yi = y(i,j)
         zi = z(i,j)

         call pbc_unfold &
     &     ( xi, yi, zi, mbox(1,i,j), mbox(2,i,j), mbox(3,i,j) )

         vir(1,1) = vir(1,1) + fx(i,j)*xi
         vir(1,2) = vir(1,2) + fx(i,j)*yi
         vir(1,3) = vir(1,3) + fx(i,j)*zi
         vir(2,1) = vir(2,1) + fy(i,j)*xi
         vir(2,2) = vir(2,2) + fy(i,j)*yi
         vir(2,3) = vir(2,3) + fy(i,j)*zi
         vir(3,1) = vir(3,1) + fz(i,j)*xi
         vir(3,2) = vir(3,2) + fz(i,j)*yi
         vir(3,3) = vir(3,3) + fz(i,j)*zi

      end do
      end do

      return
      end

