!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Nov 10, 2018 by M. Shiga
!      Description:     energy and force from Gaussian 09 calculation
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine force_g09_MPI
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   x, y, z, fx, fy, fz, pot, dipx, dipy, dipz, vir, &
     &   g09_exe_command, g09_formchk_command, iexe_grad_g09, mbox, &
     &   iexe_oniom_g09, iexe_dip_g09, iounit, iounit_g09, nbead, natom, &
     &   nprocs, myrank

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer :: ierr, ibead, iblank, i, j, ian, match, nline, itest

      real(8) :: xi, yi, zi

      character(len=128):: char_line, char_file, char_command

      character(len=128):: char_file_1, char_file_2, char_file_3

      character(len=3)::  char_num

      integer, save :: iset = 0

!-----------------------------------------------------------------------
!     /*   initialize directory                                       */
!-----------------------------------------------------------------------

      ierr = 0

      if ( iset .eq. 0 ) then

         do ibead = 1, nbead

!           /*   allocated bead only   */
            if ( mod( ibead-1, nprocs ) .ne. myrank ) cycle
            call int3_to_char( ibead, char_num )

!           /*   remove old directory and create new directory   */
            call system ('rm -f -r ./' // char_num )
            call system ('mkdir -p ./' // char_num )

         end do

!        /*   call MPI_barrier   */
         call my_mpi_barrier

         if ( myrank .eq. 0 ) then

!           /*   file open   */
            open ( iounit, file = 'input.dat' )

!           /*   search for tag    */
            call search_tag ( '<g09_command>', 13, iounit, ierr )

!           /*   read a line   */
            read ( iounit, *, iostat=ierr ) g09_exe_command

!           /*   read a line  */
            read ( iounit, *, iostat=ierr ) g09_formchk_command

!           /*   file close   */
            close ( iounit )

            if ( ierr .ne. 0 ) then

!              /*   file open   */
               open ( iounit, file = 'input_default.dat' )

!              /*   search for tag    */
               call search_tag ( '<g09_command>', 13, iounit, ierr )

!              /*   read a line
               read ( iounit, *, iostat=ierr ) g09_exe_command

!              /*   read a line
               read ( iounit, *, iostat=ierr ) g09_formchk_command

!              /*   file close   */
               close ( iounit )

            end if

!           /*   file open   */
            open ( iounit, file = 'input.dat' )

!           /*   search for tag    */
            call search_tag ( '<g09_oniom>', 11, iounit, ierr )

!           /*   read a line   */
            read ( iounit, *, iostat=ierr ) iexe_oniom_g09

!           /*   file close   */
            close ( iounit )

            if ( ierr .ne. 0 ) then

!              /*   file open   */
               open ( iounit, file = 'input_default.dat' )

!              /*   search for tag    */
               call search_tag ( '<g09_oniom>', 11, iounit, ierr )

!              /*   read a line   */
               read ( iounit, *, iostat=ierr ) iexe_oniom_g09

!              /*   file close   */
               close ( iounit )

            end if

!           /*   file open   */
            open ( iounit, file = 'input.dat' )

!           /*   search for tag    */
            call search_tag ( '<g09_grad>', 10, iounit, ierr )

!           /*   read a line   */
            read ( iounit, *, iostat=ierr ) iexe_grad_g09

!           /*   file close   */
            close ( iounit )

            if ( ierr .ne. 0 ) then

!              /*   file open   */
               open ( iounit, file = 'input_default.dat' )

!              /*   search for tag    */
               call search_tag ( '<g09_grad>', 10, iounit, ierr )

!              /*   read a line   */
               read ( iounit, *, iostat=ierr ) iexe_grad_g09

!              /*   file close   */
               close ( iounit )

            end if

!           /*   file open   */
            open ( iounit, file = 'input.dat' )

!           /*   search for tag    */
            call search_tag ( '<g09_dip>', 9, iounit, ierr )

!           /*   read a line   */
            read ( iounit, *, iostat=ierr ) iexe_dip_g09

!           /*   file close   */
            close ( iounit )

            if ( ierr .ne. 0 ) then

!              /*   file open   */
               open ( iounit, file = 'input_default.dat' )

!              /*   search for tag    */
               call search_tag ( '<g09_dip>', 9, iounit, ierr )

!              /*   read a line   */
               read ( iounit, *, iostat=ierr ) iexe_dip_g09

!              /*   file close   */
               close ( iounit )

            end if

!-----------------------------------------------------------------------
!        /*   confirm g09 command                                     */
!-----------------------------------------------------------------------

!            call system
!     &         ("echo '0' > test.out")
!            call system
!     &         ("which " // g09_exe_command //
!     &          " > /dev/null 2>&1 && echo '1' > test.out")
!            open ( iounit, file = 'test.out' )
!            read ( iounit, * ) itest
!            close( iounit )

            itest = 1

            if ( itest .eq. 0 ) then

               ierr = 1

               write( 6, '(a)' ) 'Error - G09 command not found: ' // &
     &                            trim(g09_exe_command)
               write( 6, '(a)' )

            else

               ierr = 0

               write( 6, '(a)' ) 'G09 command found: ' // &
     &                            trim(g09_exe_command)

            end if

            call system('rm -f test.out')

         end if

         call my_mpi_bcast_int_0 ( ierr )

         call error_handling_MPI &
     &       ( ierr, 'subroutine force_g09_MPI', 24 )

         call my_mpi_bcast_char_0 &
     &      ( g09_exe_command, len(g09_exe_command) )

         call my_mpi_bcast_char_0 &
     &      ( g09_formchk_command, len(g09_formchk_command) )

         call my_mpi_bcast_int_0( iexe_oniom_g09 )

         call my_mpi_bcast_int_0( iexe_grad_g09 )

         call my_mpi_bcast_int_0( iexe_dip_g09 )

         iset = 1

      end if

!-----------------------------------------------------------------------
!     /*   start loop of beads                                        */
!-----------------------------------------------------------------------

      do ibead = 1, nbead

!-----------------------------------------------------------------------
!     /*   skip if `ibead is not my job'                              */
!-----------------------------------------------------------------------

      if ( mod( ibead-1, nprocs ) .ne. myrank ) cycle

!-----------------------------------------------------------------------
!     /*   make char_num according to myrank                          */
!-----------------------------------------------------------------------

      call int3_to_char( ibead, char_num )

!-----------------------------------------------------------------------
!     /*   make g09 input:  input.g09 for non-oniom calculations      */
!-----------------------------------------------------------------------

      if ( iexe_oniom_g09 .eq. 0 ) then

!     /*   open the g09 prototype file   */
      open ( iounit,     file = 'g09.dat'   )

!     /*   open the g09 input file   */
      char_file = ('./' // char_num // '/input.g09')
      open ( iounit_g09, file = char_file )

      iblank = 0

      do

!        /*   read a line   */
         read ( iounit, '(a)', iostat=ierr ) char_line

!        /*   exit at the end of the line   */
         if ( ierr .ne. 0 ) exit

         if ( char_line(1:10) .eq. '          ' ) iblank = iblank + 1

!        /*   if two blanks have been found   */
         if ( iblank .eq. 2 ) then

!           /*   write a copy of the line   */
            write( iounit_g09, '(a)' ) char_line

!           /*   read a line   */
            read ( iounit, '(a)', iostat=ierr ) char_line

!           /*   write a copy of the line   */
            write( iounit_g09, '(a)' ) char_line

            do i = 1, natom

!              /*   read atomic number   */
               read ( iounit, * ) ian

!              /*   write atomic number and Cartesian coordinates   */
!               write( iounit_g09, '(i8,3e24.16)' )
!     &            ian, x(i,ibead), y(i,ibead), z(i,ibead)

                xi = x(i,ibead)
                yi = y(i,ibead)
                zi = z(i,ibead)

                call pbc_unfold_MPI &
     &             ( xi, yi, zi, mbox(1,i,ibead), mbox(2,i,ibead), &
     &               mbox(3,i,ibead) )

                write( iounit_g09, '(i8,3e24.16)' ) ian, xi, yi, zi

            end do

!        /*   if matched to check point file   */
         else if ( index(char_line(1:4),'%chk') .ge. 1 ) then

            char_line = ('%chk=./' // char_num //  '/chk.g09')
            write( iounit_g09, '(a)' ) char_line

!        /*   if not matched   */
         else

!           /*   write a copy of the line   */
            write( iounit_g09, '(a)' ) char_line

         end if

      end do

!     /*   add a blank line at the end   */
      write(iounit_g09,'(a)')

!     /*   close files   */
      close(iounit)
      close(iounit_g09)

      end if

!-----------------------------------------------------------------------
!     /*   make g09 input:  input.g09 for non-oniom calculations      */
!-----------------------------------------------------------------------

      if ( iexe_oniom_g09 .eq. 1 ) then

!     /*   open the g09 prototype file   */
      open ( iounit,     file = 'g09.dat'   )

!     /*   open the g09 input file   */
      char_file = ('./' // char_num // '/input.g09')
      open ( iounit_g09, file = char_file )

      iblank = 0

      do

!        /*   read a line   */
         read ( iounit, '(a)', iostat=ierr ) char_line

!        /*   exit at the end of the line   */
         if ( ierr .ne. 0 ) exit

         if ( char_line(1:10) .eq. '          ' ) iblank = iblank + 1

!        /*   if two blanks have been found   */
         if ( iblank .eq. 2 ) then

!           /*   write a copy of the line   */
            write( iounit_g09, '(a)' ) char_line

!           /*   read a line   */
            read ( iounit, '(a)', iostat=ierr ) char_line

!           /*   write a copy of the line   */
            write( iounit_g09, '(a)' ) char_line

            do i = 1, natom

!              /*   read atomic number   */
               read ( iounit, '(a)', iostat=ierr ) char_line

!              /*   write atomic number and Cartesian coordinates   */
!               write( iounit_g09, '(i8,3e24.16)' )
!     &            ian, x(i,ibead), y(i,ibead), z(i,ibead)

                xi = x(i,ibead)
                yi = y(i,ibead)
                zi = z(i,ibead)

                call pbc_unfold_MPI &
     &             ( xi, yi, zi, mbox(1,i,ibead), mbox(2,i,ibead), &
     &               mbox(3,i,ibead) )

                write( iounit_g09, '(a19,3f14.8,a19)' ) &
     &             char_line(1:19), xi, yi, zi, char_line(62:80)

            end do

!        /*   if matched to check point file   */
         else if ( index(char_line(1:4),'%chk') .ge. 1 ) then

            char_line = ('%chk=' // './' // char_num // '/chk.g09')
            write( iounit_g09, '(a)' ) char_line

!        /*   if not matched   */
         else

!           /*   write a copy of the line   */
            write( iounit_g09, '(a)' ) char_line

         end if

      end do

!     /*   add a blank line at the end   */
      write(iounit_g09,'(a)')

!     /*   close files   */
      close(iounit)
      close(iounit_g09)

      end if

!-----------------------------------------------------------------------
!     /*   run g09                                                    */
!-----------------------------------------------------------------------

!      char_command = '/appli_1/Gaussian/g09/g09'
      char_command = g09_exe_command

      char_file_1  = ('./' // char_num // '/input.g09')
      char_file_2  = ('./' // char_num // '/output.g09')

      call system ( char_command // ' < ' // char_file_1 // &
     &                              ' > ' // char_file_2 )

!      char_command = '/appli_1/Gaussian/g09/formchk'
      char_command = g09_formchk_command

      char_file_1  = ('./' // char_num // '/chk.g09')
      char_file_2  = ('./' // char_num // '/fchk.g09')
      char_file_3  = ('./' // char_num // '/log.g09')

      call system ( char_command // ' ' // char_file_1 // ' ' &
     &              // char_file_2 // ' > ' // char_file_3 )

!-----------------------------------------------------------------------
!     /*   read g09 output:  potential                                */
!-----------------------------------------------------------------------

!     /*   open the g09 output file   */
      char_file = ('./' // char_num // '/fchk.g09')
      open ( iounit_g09, file = char_file )

!     /*   set file name   */
      char_file  = ('./' // char_num // '/scratch.g09')

!     /*   do loop start   */
      do

!        /*   read a line   */
         read ( iounit_g09, '(a)', iostat=ierr ) char_line

!        /*   error handling   */
         if ( ierr .ne. 0 ) then
            close(iounit_g09)
            call system('sleep 1')
            char_command = g09_formchk_command
            char_file_1  = ('./' // char_num // '/chk.g09')
            char_file_2  = ('./' // char_num // '/fchk.g09')
            char_file_3  = ('./' // char_num // '/log.g09')
            call system ( char_command // ' ' // char_file_1 // ' ' &
     &                    // char_file_2 // ' > ' // char_file_3 )
            call system('sleep 1')
            char_file = ('./' // char_num // '/fchk.g09')
            open ( iounit_g09, file = char_file )
            char_file  = ('./' // char_num // '/scratch.g09')
            read ( iounit_g09, '(a)', iostat=ierr ) char_line
         end if

!        /*   see if the line matches   */
         match = index( char_line(1:12), 'Total Energy' )

!        /*   if matched   */
         if ( match .ge. 1 ) then

!           /*   write potential data to a scratch file   */
            open ( iounit, file = char_file )
               write (iounit,'(a)') char_line(48:72)
            close( iounit )

!           /*   read the potential data   */
            open ( iounit, file = char_file )
               read (iounit,*) pot(ibead)
            close( iounit )

!           /*   delete scratch file   */
            call system( 'rm -f ' // char_file )

!           /*   exit from the do loop   */
            exit

         end if

!     /*   do loop end   */
      end do

!     /*   close file   */
      close(iounit_g09)

!-----------------------------------------------------------------------
!     /*   read g09 output:  potential gradient                       */
!-----------------------------------------------------------------------

      if ( iexe_grad_g09 .eq. 0 ) then

         do i = 1, natom
            fx(i,ibead) = 0.d0
            fy(i,ibead) = 0.d0
            fz(i,ibead) = 0.d0
         end do

      else

!        /*   open the g09 output file   */
         char_file  = ('./' // char_num // '/fchk.g09')
         open ( iounit_g09, file = char_file )

!        /*   set file name   */
         char_file  = ('./' // char_num // '/scratch.g09')

!        /*   do loop start   */
         do

!        /*   read a line   */
         read ( iounit_g09, '(a)', iostat=ierr ) char_line

!        /*   see if the line matches   */
         match = index( char_line(1:18), 'Cartesian Gradient' )

!        /*   if matched   */
         if ( match .ge. 1 ) then

!           /*   open scratch file   */
            open ( iounit, file = char_file )

!           /*   count number of lines need to be read   */

            if ( mod(natom*3,5) .eq. 0 ) nline = (natom*3)/5
            if ( mod(natom*3,5) .ne. 0 ) nline = (natom*3)/5 + 1

            do i = 1, nline

!              /*   read potential gradient data from g09 output   */
               read ( iounit_g09, '(a)', iostat=ierr ) char_line

!              /*    write potential gradient data to scratch file   */

               write (iounit,'(a)') char_line( 1:16)
               write (iounit,'(a)') char_line(17:32)
               write (iounit,'(a)') char_line(33:48)
               write (iounit,'(a)') char_line(49:64)
               write (iounit,'(a)') char_line(65:80)

            end do

!           /*   close scratch file   */
            close(iounit)

!           /*   open scratch file   */
            char_file = ('./' // char_num // '/scratch.g09')
            open ( iounit, file = char_file )

!              /*   read potential gradient data   */

               do i = 1, natom
                  read ( iounit, * ) fx(i,ibead)
                  read ( iounit, * ) fy(i,ibead)
                  read ( iounit, * ) fz(i,ibead)
               end do

!              /*   change sign:  gradient -> force   */

               do i = 1, natom
                  fx(i,ibead) = - fx(i,ibead)
                  fy(i,ibead) = - fy(i,ibead)
                  fz(i,ibead) = - fz(i,ibead)
               end do

            close(iounit)

!           /*   delete scratch file   */
            call system( 'rm -f ' // char_file )

!           /*   exit from the do loop   */
            exit

         end if

!        /*   do loop end   */
         end do

!        /*   close file   */
         close( iounit_g09 )

      end if

!-----------------------------------------------------------------------
!     /*   read g09 output:  dipole moment                            */
!-----------------------------------------------------------------------

      if ( iexe_dip_g09 .eq. 0 ) then

         dipx(ibead) = 0.d0
         dipy(ibead) = 0.d0
         dipz(ibead) = 0.d0

      else

!        /*   open the g09 output file   */
         char_file  = ('./' // char_num // '/fchk.g09')
         open ( iounit_g09, file = char_file )

!        /*   do loop start   */
         do

!        /*   read a line   */
         read ( iounit_g09, '(a)', iostat=ierr ) char_line

!        /*   see if the line matches   */
         match = index( char_line(1:13), 'Dipole Moment' )

!        /*   if matched   */
         if ( match .ge. 1 ) then

!           /*   read dipole moment data   */
            read( iounit_g09, * ) dipx(ibead), dipy(ibead), dipz(ibead)

!           /*   exit from the do loop   */
            exit

         end if

!        /*   do loop end   */
         end do

!        /*   close file   */
         close( iounit_g09 )

      end if

!-----------------------------------------------------------------------
!     /*   end loop of beads                                          */
!-----------------------------------------------------------------------

      end do

!-----------------------------------------------------------------------
!     /*   remove unnecessary files                                   */
!-----------------------------------------------------------------------

!      call system ( 'rm -f Gau*' )

!-----------------------------------------------------------------------
!     /*   all-reduce communication                                   */
!-----------------------------------------------------------------------

!     /*   potential   */
      call my_mpi_allreduce_real_1 ( pot, nbead )

!     /*   force   */
      call my_mpi_allreduce_real_2 ( fx, natom, nbead )
      call my_mpi_allreduce_real_2 ( fy, natom, nbead )
      call my_mpi_allreduce_real_2 ( fz, natom, nbead )

!     /*   dipole   */
      call my_mpi_allreduce_real_1 ( dipx, nbead )
      call my_mpi_allreduce_real_1 ( dipy, nbead )
      call my_mpi_allreduce_real_1 ( dipz, nbead )

!-----------------------------------------------------------------------
!     /*   virial                                                     */
!-----------------------------------------------------------------------

      do j = 1, nbead
      do i = 1, natom

         xi = x(i,j)
         yi = y(i,j)
         zi = z(i,j)

         call pbc_unfold_MPI &
     &     ( xi, yi, zi, mbox(1,i,j), mbox(2,i,j), mbox(3,i,j) )

         vir(1,1) = vir(1,1) + fx(i,j)*xi
         vir(1,2) = vir(1,2) + fx(i,j)*yi
         vir(1,3) = vir(1,3) + fx(i,j)*zi
         vir(2,1) = vir(2,1) + fy(i,j)*xi
         vir(2,2) = vir(2,2) + fy(i,j)*yi
         vir(2,3) = vir(2,3) + fy(i,j)*zi
         vir(3,1) = vir(3,1) + fz(i,j)*xi
         vir(3,2) = vir(3,2) + fz(i,j)*yi
         vir(3,3) = vir(3,3) + fz(i,j)*zi

      end do
      end do

      return
      end

