!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Nov 10, 2018 by M. Shiga
!      Description:     add external force
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine force_me_external_s_MPI
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   mechanical force                                           */
!-----------------------------------------------------------------------

      call force_mech_MPI

      call force_freeze_MPI

      call force_me_mech_s_MPI

!-----------------------------------------------------------------------
!     /*   best for qmmm                                              */
!-----------------------------------------------------------------------

      call force_best_MPI

      call force_me_best_s_MPI

      return
      end





!***********************************************************************
      subroutine force_me_mech_s_MPI
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use qmmm_variables, only : &
     &   pot_b, fx_b, fy_b, fz_b, vir_b

      use mech_variables, only : &
     &   pot_mech, fx_mech, fy_mech, fz_mech, vir_mech, mech_type

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

!-----------------------------------------------------------------------
!     /*   skip if mechanical force is zero                           */
!-----------------------------------------------------------------------

      if ( mech_type(1:5) .eq. 'NONE ' ) return

!-----------------------------------------------------------------------
!     /*   add contributions                                          */
!-----------------------------------------------------------------------

      pot_b(:) = pot_b(:) + pot_mech(:)

      fx_b(:,:) = fx_b(:,:) + fx_mech(:,:)
      fy_b(:,:) = fy_b(:,:) + fy_mech(:,:)
      fz_b(:,:) = fz_b(:,:) + fz_mech(:,:)

      vir_b(:,:) = vir_b(:,:) + vir_mech(:,:)

      return
      end





!***********************************************************************
      subroutine force_me_best_s_MPI
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use qmmm_variables, only : &
     &   pot_b, fx_b, fy_b, fz_b, vir_b

      use best_variables, only : &
     &   pot_best, fx_best, fy_best, fz_best, vir_best, ioption_best

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

!-----------------------------------------------------------------------
!     /*   skip if best is off                                        */
!-----------------------------------------------------------------------

      if ( ioption_best .eq. 0 ) return

!-----------------------------------------------------------------------
!     /*   add contributions                                          */
!-----------------------------------------------------------------------

      pot_b(:) = pot_b(:) + pot_best(:)

      fx_b(:,:) = fx_b(:,:) + fx_best(:,:)
      fy_b(:,:) = fy_b(:,:) + fy_best(:,:)
      fz_b(:,:) = fz_b(:,:) + fz_best(:,:)

      vir_b(:,:) = vir_b(:,:) + vir_best(:,:)

      return
      end
