!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Nov 10, 2018 by M. Shiga
!      Description:     cartesian forces
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine force_cart
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   x, y, z, fx, fy, fz, pot, vir, nbead

      use cart_variables, only : &
     &   eqx_cart, eqy_cart, eqz_cart, fc_cart, &
     &   ncart, i_cart, nx_cart, ny_cart, nz_cart

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer :: m, k, i, nx, ny, nz

      real(8) :: dx, dy, dz, dxn, dyn, dzn, ddx, ddy, ddz, fc

      integer, save :: iset = 0

!-----------------------------------------------------------------------
!     /*   initialize                                                 */
!-----------------------------------------------------------------------

      if ( iset .eq. 0 ) then

         call force_cart_setup

         iset = 1

      end if

!-----------------------------------------------------------------------
!     /*   no potential                                               */
!-----------------------------------------------------------------------

      if ( ncart .eq. 0 ) return

!-----------------------------------------------------------------------
!     /*   main loop                                                  */
!-----------------------------------------------------------------------

      do m = 1, nbead

         do k = 1, ncart

            i = i_cart(k)

            fc = fc_cart(k)

            dx = x(i,m) - eqx_cart(k)
            dy = y(i,m) - eqy_cart(k)
            dz = z(i,m) - eqz_cart(k)

            nx = nx_cart(k)
            ny = ny_cart(k)
            nz = nz_cart(k)

            if      ( nx .eq. 0 ) then
               dxn = 1.d0
               ddx = 0.d0
            else if ( nx .eq. 1 ) then
               dxn = dx
               ddx = 1.d0
            else if ( nx .eq. 2 ) then
               dxn = dx * dx
               ddx = 2.d0 * dx
            else if ( nx .eq. 3 ) then
               dxn = dx * dx * dx
               ddx = 3.d0 * dx * dx
            else if ( nx .eq. 4 ) then
               dxn = dx * dx * dx * dx
               ddx = 4.d0 * dx * dx * dx
            else
               dxn = dx**nx
               ddx = nx * dx**(nx-1)
            end if

            if      ( ny .eq. 0 ) then
               dyn = 1.d0
               ddy = 0.d0
            else if ( ny .eq. 1 ) then
               dyn = dy
               ddy = 1.d0
            else if ( ny .eq. 2 ) then
               dyn = dy * dy
               ddy = 2.d0 * dy
            else if ( ny .eq. 3 ) then
               dyn = dy * dy * dy
               ddy = 3.d0 * dy * dy
            else if ( ny .eq. 4 ) then
               dyn = dy * dy * dy * dy
               ddy = 4.d0 * dy * dy * dy
            else
               dyn = dy**ny
               ddy = ny * dy**(ny-1)
            end if

            if      ( nz .eq. 0 ) then
               dzn = 1.d0
               ddz = 0.d0
            else if ( nz .eq. 1 ) then
               dzn = dz
               ddz = 1.d0
            else if ( nz .eq. 2 ) then
               dzn = dz * dz
               ddz = 2.d0 * dz
            else if ( nz .eq. 3 ) then
               dzn = dz * dz * dz
               ddz = 3.d0 * dz * dz
            else if ( nz .eq. 4 ) then
               dzn = dz * dz * dz * dz
               ddz = 4.d0 * dz * dz * dz
            else
               dzn = dz**nz
               ddz = nz * dz**(nz-1)
            end if

            pot(m) = pot(m) + fc * dxn * dyn * dzn

            fx(i,m) = fx(i,m) - fc * ddx * dyn * dzn
            fy(i,m) = fy(i,m) - fc * dxn * ddy * dzn
            fz(i,m) = fz(i,m) - fc * dyn * dyn * ddz

         end do

      end do

      vir(:,:) = 0.d0

      return
      end





!***********************************************************************
      subroutine force_cart_setup
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   iounit

      use cart_variables, only : &
     &   eqx_cart, eqy_cart, eqz_cart, fc_cart, &
     &   ncart, i_cart, nx_cart, ny_cart, nz_cart

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer k, ierr

!-----------------------------------------------------------------------
!     /*   set up                                                     */
!-----------------------------------------------------------------------

      open ( iounit, file = 'cart.dat' )

!        /*   tag   */
         call search_tag ( '<ncart>', 7, iounit, ierr )

!        /*   number of terms   */
         if ( ierr .eq. 0 ) read( iounit, *, iostat=ierr ) ncart

      close( iounit )

      if ( ierr .ne. 0 ) ncart = 0

      if ( ncart .eq. 0 ) return

      if ( .not. allocated(   i_cart ) ) &
     &   allocate(   i_cart(ncart) )
      if ( .not. allocated(  nx_cart ) ) &
     &   allocate(  nx_cart(ncart) )
      if ( .not. allocated(  ny_cart ) ) &
     &   allocate(  ny_cart(ncart) )
      if ( .not. allocated(  nz_cart ) ) &
     &   allocate(  nz_cart(ncart) )
      if ( .not. allocated( eqx_cart ) ) &
     &   allocate( eqx_cart(ncart) )
      if ( .not. allocated( eqy_cart ) ) &
     &   allocate( eqy_cart(ncart) )
      if ( .not. allocated( eqz_cart ) ) &
     &   allocate( eqz_cart(ncart) )
      if ( .not. allocated(  fc_cart ) ) &
     &   allocate(  fc_cart(ncart) )

      open ( iounit, file = 'cart.dat' )

!        /*   tag   */
         call search_tag ( '<ncart>', 7, iounit, ierr )

!        /*   number of terms   */
         read( iounit, *, iostat=ierr ) ncart

!        /*   atom, power, equilibrium   */
         do k = 1, ncart
            read( iounit, *, iostat=ierr ) &
     &         i_cart(k), nx_cart(k), ny_cart(k), nz_cart(k), &
     &         eqx_cart(k), eqy_cart(k), eqz_cart(k), fc_cart(k)
         end do

      close( iounit )

      return
      end
