!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Nov 10, 2018 by M. Shiga
!      Description:     energy and force from ABINIT-MP calculation
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine force_abinit_mp5_MPI
!***********************************************************************

      use common_variables, only : myrank

      implicit none

      if ( myrank .eq. 0 ) then

         write( 6, '(a)' ) &
     &      'Error - ABINIT-MP5 (parallel) is not supported.'
         write( 6, '(a)' ) &
     &      'Try ABINIT-MP5 (serial) or ABINIT-MP (parallel).'
         write( 6, '(a)' )

      end if

      call error_handling_MPI ( 1, 'subroutine force_abinit_MPI', 27 )

      return
      end

