!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Nov 10, 2018 by M. Shiga
!      Description:     replica exchange
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine exchange_rem_rehmc(i,j)
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   fux, fuy, fuz, x, y, z, ux, uy, uz, fx, fy, fz, pot, natom

      use rehmc_variables, only : &
     &   hamiltonian_bead

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer :: i, j, k

!-----------------------------------------------------------------------
!     /*   exchange between i and j: x, y, z                          */
!-----------------------------------------------------------------------

      do k = 1, natom

         fux(k,j)  = x(k,j)
         fuy(k,j)  = y(k,j)
         fuz(k,j)  = z(k,j)

         x(k,j)    = x(k,i)
         y(k,j)    = y(k,i)
         z(k,j)    = z(k,i)

         x(k,i)    = fux(k,j)
         y(k,i)    = fuy(k,j)
         z(k,i)    = fuz(k,j)

      end do

!-----------------------------------------------------------------------
!     /*   exchange between i and j: ux, uy, uz                       */
!-----------------------------------------------------------------------

      do k = 1, natom

         fux(k,j)  = ux(k,j)
         fuy(k,j)  = uy(k,j)
         fuz(k,j)  = uz(k,j)

         ux(k,j)   = ux(k,i)
         uy(k,j)   = uy(k,i)
         uz(k,j)   = uz(k,i)

         ux(k,i)   = fux(k,j)
         uy(k,i)   = fuy(k,j)
         uz(k,i)   = fuz(k,j)

      end do

!-----------------------------------------------------------------------
!     /*   exchange between i and j: fx, fy, fz                       */
!-----------------------------------------------------------------------

      do k = 1, natom

         fux(k,j)  = fx(k,j)
         fuy(k,j)  = fy(k,j)
         fuz(k,j)  = fz(k,j)

         fx(k,j)   = fx(k,i)
         fy(k,j)   = fy(k,i)
         fz(k,j)   = fz(k,i)

         fx(k,i)   = fux(k,j)
         fy(k,i)   = fuy(k,j)
         fz(k,i)   = fuz(k,j)

      end do

!-----------------------------------------------------------------------
!     /*   exchange between i and j: pot                              */
!-----------------------------------------------------------------------

      fux(1,1)  = pot(j)
      pot(j)    = pot(i)
      pot(i)    = fux(1,1)

!-----------------------------------------------------------------------
!     /*   exchange between i and j: hamiltonian_bead                 */
!-----------------------------------------------------------------------

      fux(1,1)               = hamiltonian_bead(j)
      hamiltonian_bead(j)    = hamiltonian_bead(i)
      hamiltonian_bead(i)    = fux(1,1)

      return
      end





!***********************************************************************
      subroutine exchange_rex_rehmc(i,j)
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   fux, fuy, fuz, x, y, z, ux, uy, uz, fx, fy, fz, pot, &
     &   natom, nbead

      use alchem_variables, only : &
     &   pot_alchem, fx_alchem, fy_alchem, fz_alchem

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer :: i, j, k, l

!-----------------------------------------------------------------------
!     /*   exchange between i and j: x, y, z                          */
!-----------------------------------------------------------------------

      do k = 1, natom

         fux(k,j)  = x(k,j)
         fuy(k,j)  = y(k,j)
         fuz(k,j)  = z(k,j)

         x(k,j)    = x(k,i)
         y(k,j)    = y(k,i)
         z(k,j)    = z(k,i)

         x(k,i)    = fux(k,j)
         y(k,i)    = fuy(k,j)
         z(k,i)    = fuz(k,j)

      end do

!-----------------------------------------------------------------------
!     /*   exchange between i and j: ux, uy, uz                       */
!-----------------------------------------------------------------------

      do k = 1, natom

         fux(k,j)  = ux(k,j)
         fuy(k,j)  = uy(k,j)
         fuz(k,j)  = uz(k,j)

         ux(k,j)   = ux(k,i)
         uy(k,j)   = uy(k,i)
         uz(k,j)   = uz(k,i)

         ux(k,i)   = fux(k,j)
         uy(k,i)   = fuy(k,j)
         uz(k,i)   = fuz(k,j)

      end do

!-----------------------------------------------------------------------
!     /*   exchange between i and j: pot                              */
!-----------------------------------------------------------------------

      pot(j) = pot_alchem(j,i)
      pot(i) = pot_alchem(i,j)

!-----------------------------------------------------------------------
!     /*   exchange between i and j: pot_alchem                       */
!-----------------------------------------------------------------------

      do k = 1, nbead

         fux(1,i)         = pot_alchem(k,i)
         pot_alchem(k,i)  = pot_alchem(k,j)
         pot_alchem(k,j)  = fux(1,i)

      end do

!-----------------------------------------------------------------------
!     /*   exchange between i and j: fx, fy, fz                       */
!-----------------------------------------------------------------------

      do k = 1, natom

         fx(k,j)   = fx_alchem(k,j,i)
         fy(k,j)   = fy_alchem(k,j,i)
         fz(k,j)   = fz_alchem(k,j,i)

         fx(k,i)   = fx_alchem(k,i,j)
         fy(k,i)   = fy_alchem(k,i,j)
         fz(k,i)   = fz_alchem(k,i,j)

      end do

!-----------------------------------------------------------------------
!     /*   exchange between i and j: fx_alchem, fy_alchem, fz_alchem  */
!-----------------------------------------------------------------------

      do k = 1, nbead
      do l = 1, natom

         fux(1,i)          = fx_alchem(l,k,i)
         fx_alchem(l,k,i)  = fx_alchem(l,k,j)
         fx_alchem(l,k,j)  = fux(1,i)

         fuy(1,i)          = fy_alchem(l,k,i)
         fy_alchem(l,k,i)  = fy_alchem(l,k,j)
         fy_alchem(l,k,j)  = fuy(1,i)

         fuz(1,i)          = fz_alchem(l,k,i)
         fz_alchem(l,k,i)  = fz_alchem(l,k,j)
         fz_alchem(l,k,j)  = fuz(1,i)

      end do
      end do

      return
      end





!***********************************************************************
      subroutine exchange_rem_rehmc_npt(i,j)
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   fux, fuy, fuz, x, y, z, ux, uy, uz, fx, fy, fz, pot, &
     &   box_bead, boxinv_bead, volume_bead, vir_bead, natom

      use rehmc_variables, only : &
     &   hamiltonian_bead

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer :: i, j, k, l

!-----------------------------------------------------------------------
!     /*   exchange between i and j: x, y, z                          */
!-----------------------------------------------------------------------

      do k = 1, natom

         fux(k,j)  = x(k,j)
         fuy(k,j)  = y(k,j)
         fuz(k,j)  = z(k,j)

         x(k,j)    = x(k,i)
         y(k,j)    = y(k,i)
         z(k,j)    = z(k,i)

         x(k,i)    = fux(k,j)
         y(k,i)    = fuy(k,j)
         z(k,i)    = fuz(k,j)

      end do

!-----------------------------------------------------------------------
!     /*   exchange between i and j: ux, uy, uz                       */
!-----------------------------------------------------------------------

      do k = 1, natom

         fux(k,j)  = ux(k,j)
         fuy(k,j)  = uy(k,j)
         fuz(k,j)  = uz(k,j)

         ux(k,j)   = ux(k,i)
         uy(k,j)   = uy(k,i)
         uz(k,j)   = uz(k,i)

         ux(k,i)   = fux(k,j)
         uy(k,i)   = fuy(k,j)
         uz(k,i)   = fuz(k,j)

      end do

!-----------------------------------------------------------------------
!     /*   exchange between i and j: fx, fy, fz                       */
!-----------------------------------------------------------------------

      do k = 1, natom

         fux(k,j)  = fx(k,j)
         fuy(k,j)  = fy(k,j)
         fuz(k,j)  = fz(k,j)

         fx(k,j)   = fx(k,i)
         fy(k,j)   = fy(k,i)
         fz(k,j)   = fz(k,i)

         fx(k,i)   = fux(k,j)
         fy(k,i)   = fuy(k,j)
         fz(k,i)   = fuz(k,j)

      end do

!-----------------------------------------------------------------------
!     /*   exchange between i and j: pot                              */
!-----------------------------------------------------------------------

      fux(1,1)  = pot(j)
      pot(j)    = pot(i)
      pot(i)    = fux(1,1)

!-----------------------------------------------------------------------
!     /*   exchange between i and j: hamiltonian_bead                 */
!-----------------------------------------------------------------------

      fux(1,1)               = hamiltonian_bead(j)
      hamiltonian_bead(j)    = hamiltonian_bead(i)
      hamiltonian_bead(i)    = fux(1,1)

!-----------------------------------------------------------------------
!     /*   exchange between i and j: box_bead                         */
!-----------------------------------------------------------------------

      do l = 1, 3
      do k = 1, 3
         fux(1,1)        = box_bead(k,l,j)
         box_bead(k,l,j) = box_bead(k,l,i)
         box_bead(k,l,i) = fux(1,1)
      end do
      end do

!-----------------------------------------------------------------------
!     /*   exchange between i and j: boxinv_bead                      */
!-----------------------------------------------------------------------

      do l = 1, 3
      do k = 1, 3
         fux(1,1)           = boxinv_bead(k,l,j)
         boxinv_bead(k,l,j) = boxinv_bead(k,l,i)
         boxinv_bead(k,l,i) = fux(1,1)
      end do
      end do

!-----------------------------------------------------------------------
!     /*   exchange between i and j: volume_bead                      */
!-----------------------------------------------------------------------

      fux(1,1)          = volume_bead(j)
      volume_bead(j)    = volume_bead(i)
      volume_bead(i)    = fux(1,1)

!-----------------------------------------------------------------------
!     /*   exchange between i and j: vir_bead                         */
!-----------------------------------------------------------------------

      do l = 1, 3
      do k = 1, 3
         fux(1,1)        = vir_bead(k,l,j)
         vir_bead(k,l,j) = vir_bead(k,l,i)
         vir_bead(k,l,i) = fux(1,1)
      end do
      end do

      return
      end





!***********************************************************************
      subroutine exchange_rem_remc(i,j)
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   fux, fuy, fuz, x, y, z, ux, uy, uz, fx, fy, fz, pot, natom

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer :: i, j, k

!-----------------------------------------------------------------------
!     /*   exchange between i and j: x, y, z                          */
!-----------------------------------------------------------------------

      do k = 1, natom

         fux(k,j)  = x(k,j)
         fuy(k,j)  = y(k,j)
         fuz(k,j)  = z(k,j)

         x(k,j)    = x(k,i)
         y(k,j)    = y(k,i)
         z(k,j)    = z(k,i)

         x(k,i)    = fux(k,j)
         y(k,i)    = fuy(k,j)
         z(k,i)    = fuz(k,j)

      end do

!-----------------------------------------------------------------------
!     /*   exchange between i and j: ux, uy, uz                       */
!-----------------------------------------------------------------------

      do k = 1, natom

         fux(k,j)  = ux(k,j)
         fuy(k,j)  = uy(k,j)
         fuz(k,j)  = uz(k,j)

         ux(k,j)   = ux(k,i)
         uy(k,j)   = uy(k,i)
         uz(k,j)   = uz(k,i)

         ux(k,i)   = fux(k,j)
         uy(k,i)   = fuy(k,j)
         uz(k,i)   = fuz(k,j)

      end do

!-----------------------------------------------------------------------
!     /*   exchange between i and j: fx, fy, fz                       */
!-----------------------------------------------------------------------

      do k = 1, natom

         fux(k,j)  = fx(k,j)
         fuy(k,j)  = fy(k,j)
         fuz(k,j)  = fz(k,j)

         fx(k,j)   = fx(k,i)
         fy(k,j)   = fy(k,i)
         fz(k,j)   = fz(k,i)

         fx(k,i)   = fux(k,j)
         fy(k,i)   = fuy(k,j)
         fz(k,i)   = fuz(k,j)

      end do

!-----------------------------------------------------------------------
!     /*   exchange between i and j: pot                              */
!-----------------------------------------------------------------------

      fux(1,1)  = pot(j)
      pot(j)    = pot(i)
      pot(i)    = fux(1,1)

      return
      end
