c///////////////////////////////////////////////////////////////////////
c
c      Author:          
c      Last updated:    Nov 10, 2018 by M. Shiga
c      Description:     Matrix diagonalization
c
c///////////////////////////////////////////////////////////////////////
#ifdef nolapack
      SUBROUTINE DDIAG(A,E,C,N)
C    ###############################################################
C     MATRIX DIAGONALIZATION ROUTINE FOR REAL SYMMETRIC CASE.
C     HOUSEHOLDER METHOD.
C     RHO  = UPPER LIMIT FOR OFF-DIAGONAL ELEMENT.
C     RHOSQ= 1.0D-16 1.0D-28 ,STANDARD :1.0D-18
C     N = SIZE OF MATRIX
C     A = MATRIX (ONLY LOWER TRIANGLE IS USED + THIS IS DESTROYED.)
C                      A(I,J) ; I>=J
C     E = RETURNED EIGENVALUES IN ALGEBRAIC DESCENDING ORDER
C     C = RETURNED EIGENVECTORS IN COLUMNS
C    ###############################################################
      IMPLICIT REAL*8 (A-H,O-Z)
      INTEGER N,NN,IPOSV,IVPOS,IORD,I,J,I1,M,NPAS
      REAL*8 A,BETA,BETASQ,C,E,GAMMA,ONE,P,PT5,Q,RHOSQ,TWO,W,ZERO
      INTEGER ITEMP,K,L,LV,N1,N2,NP,NR,NRR,NT,NV
      REAL*8 A2, B,CIJ,CIJ1,COSA,COSAP,D,DIA,DIF,DSQRTS,G,PP,PPBS,
     &   PPBR,QJ,R1,R12,R2,S,SHIFT,SINA,SINA2,SGN,SUM,TEMP,WJ,WTAW,U
      PARAMETER (NN=10000)
      DIMENSION A(N,N),E(N),C(N,N)
      DIMENSION GAMMA(NN),BETA(NN),BETASQ(NN),W(NN),P(NN),Q(NN),
     1          IPOSV(NN),IVPOS(NN),IORD(NN)
      EQUIVALENCE (P(1),Q(1),IVPOS(1),BETA(1))
      EQUIVALENCE (IPOSV(1),GAMMA(1)),(IORD(1),BETASQ(1))
      DATA ZERO,PT5,ONE,TWO /0.0D0,0.5D0,1.0D0,2.0D0/
      DATA RHOSQ/1.0D-99/
C
      N1=N-1
      N2=N-2
C
C===== TRANSFORM A INTO INTO THE TRIDIAGONAL MATRIX =====
      GAMMA(1)=A(1,1)
      IF(N2.LT.0) GO TO 180
      IF(N2.EQ.0) GO TO 170
      IF(N2.GT.0) GO TO 20
   20 DO 160 NR=1,N2
      B=A(NR+1,NR)
      S=ZERO
      DO 30 I=NR,N2
   30 S=S+A(I+2,NR)*A(I+2,NR)
C----- PREPARE FOR POSSIBLE BYPASS OF TRANSFORMATION -----
      A(NR+1,NR)=ZERO
      IF(S.LE.ZERO) GO TO 150
      S=S+B*B
      SGN=+ONE
      IF(B.LT.ZERO) SGN=-ONE
      DSQRTS=DSQRT(S)
      D=SGN/(DSQRTS+DSQRTS)
      TEMP=DSQRT(PT5+B*D)
      W(NR)=TEMP
      A(NR+1,NR)=TEMP
      D=D/TEMP
      B=-SGN*DSQRTS
C----- D IS FACTOR OF PROPORTIONALITY. NOW COMPUTE AND SAVE W VECTOR.
C      EXTRA SINGLY SUBSCRIPTED W VECTOR USED FOR SPEED. -----
      DO 70 I=NR,N2
      TEMP=D*A(I+2,NR)
      W(I+1)=TEMP
   70 A(I+2,NR)=TEMP
C----- PREMULTIPLY VECTOR W BY MATRIX A TO OBTAIN P VECTOR.
C      SIMULTANEOUSLY ACCUMULATE DOT PRODUCT WP,(THE SCALAR K) -----
      WTAW=ZERO
      DO 120 I=NR,N1
      SUM=ZERO
      DO 80 J=NR,I
   80 SUM=SUM+A(I+1,J+1)*W(J)
      I1=I+1
      IF(N1.LT.I1) GO TO 110
      DO 100 J=I1,N1
  100 SUM=SUM+A(J+1,I+1)*W(J)
  110 P(I)=SUM
  120 WTAW=WTAW+SUM*W(I)
C----- P VECTOR AND SCALAR K NOW STORED. NEXT COMPUTE Q VECTOR. -----
      DO 130 I=NR,N1
  130 Q(I)=P(I)-WTAW*W(I)
C----- NOW FORM PAP MATRIX, REQUIRED PART -----
      DO 140 J=NR,N1
      QJ=Q(J)
      WJ=W(J)
      DO 140 I=J,N1
  140 A(I+1,J+1)=A(I+1,J+1)-TWO*(W(I)*QJ+WJ*Q(I))
  150 BETA(NR)=B
      BETASQ(NR)=B*B
      GAMMA(NR+1)=A(NR+1,NR+1)
  160 CONTINUE
  170 B=A(N,N-1)
      BETA(N-1)=B
      BETASQ(N-1)=B*B
      GAMMA(N)=A(N,N)
  180 BETASQ(N)=ZERO
C
C===== DIAGONALIZED BY JACOBI METHOD =====
      DO 200 I=1,N
      DO 190 J=1,N
  190 C(I,J)=ZERO
  200 C(I,I)=ONE
      M=N
      SUM=ZERO
      NPAS=1
      GO TO 330
  210 SUM=SUM+SHIFT
      COSA=ONE
      G=GAMMA(1)-SHIFT
      PP=G
      PPBS=PP*PP+BETASQ(1)
      PPBR=DSQRT(PPBS)
      DO 300 J=1,M
      COSAP=COSA
      IF(PPBS.EQ.ZERO) THEN
      SINA=ZERO
      SINA2=ZERO
      COSA=ONE
      ELSE
      SINA=BETA(J)/PPBR
      SINA2=BETASQ(J)/PPBS
      COSA=PP/PPBR
C----- POSTMULTIPLY IDENTITY BY P-TRANSPOSE MATRIX -----
      NT=J+NPAS
      IF(NT.GE.N) NT=N
      DO 260 I=1,NT
      CIJ=C(I,J)
      CIJ1=C(I,J+1)
      C(I,J)=COSA*CIJ+SINA*CIJ1
  260 C(I,J+1)=-SINA*CIJ+COSA*CIJ1
      END IF
      DIA=GAMMA(J+1)-SHIFT
      U=SINA2*(G+DIA)
      GAMMA(J)=G+U
      G=DIA-U
      PP=DIA*COSA-SINA*COSAP*BETA(J)
      IF(J.EQ.M) GO TO 310
      PPBS=PP*PP+BETASQ(J+1)
      PPBR=DSQRT(PPBS)
      BETA(J)=SINA*PPBR
      BETASQ(J)=SINA2*PPBS
  300 CONTINUE
  310 BETA(M)=SINA*PP
      BETASQ(M)=SINA2*PP*PP
      GAMMA(M+1)=G
C----- TEST FOR CONVERGENCE OF LAST DIAGONAL ELMENT -----
      NPAS=NPAS+1
      IF(BETASQ(M).GT.RHOSQ) GO TO 350
  320 E(M+1)=GAMMA(M+1)+SUM
  330 BETA(M)=ZERO
      BETASQ(M)=ZERO
      M=M-1
      IF(M.EQ.0) GO TO 380
      IF(BETASQ(M).LE.RHOSQ) GO TO 320
C----- TAKE ROOT OF CORNER 2 BY 2 NEAREST TO LOWER DIAGONAL IN VALLUE
C      AS ESTIMATE OF EIGENVALUE TO USE FOR SHIFT -----
  350 A2=GAMMA(M+1)
      R2=PT5*A2
      R1=PT5*GAMMA(M)
      R12=R1+R2
      DIF=R1-R2
      TEMP=DSQRT(DIF*DIF+BETASQ(M))
      R1=R12+TEMP
      R2=R12-TEMP
      DIF=DABS(A2-R1)-DABS(A2-R2)
      SHIFT=R2
      IF(DIF.LT.ZERO) SHIFT=R1
      GO TO 210
  380 E(1)=GAMMA(1)+SUM
C
C===== ORDER THE EIGENVALUES AND REARRANGE THE EIGENVECTORS =====
      DO 390 J=1,N
      IPOSV(J)=J
      IVPOS(J)=J
  390 IORD(J)=J
      DO 420 I=2,N
      M=N-I+1
      DO 420 J=1,M
      IF(E(J).LE.E(J+1)) GO TO 420
      TEMP=E(J)
      E(J)=E(J+1)
      E(J+1)=TEMP
      ITEMP=IORD(J)
      IORD(J)=IORD(J+1)
      IORD(J+1)=ITEMP
  420 CONTINUE
      IF(N1.EQ.0) GO TO 490
      DO 480 L=1,N1
      NV=IORD(L)
      NP=IPOSV(NV)
      IF(NP.EQ.L) GO TO 480
      LV=IVPOS(L)
      IVPOS(NP)=LV
      IPOSV(LV)=NP
      DO 470 I=1,N
      TEMP=C(I,L)
      C(I,L)=C(I,NP)
  470 C(I,NP)=TEMP
  480 CONTINUE
C
C===== BACK TRANSFORM THE EIGENVECTORS OF THE TRIDIAGONAL MATRIX =====
  490 DO 540 NRR=1,N
      DO 540 J=1,N2
      K=N1-J
      SUM=ZERO
      DO 520 I=K,N1
  520 SUM=SUM+C(I+1,NRR)*A(I+1,K)
      SUM=SUM+SUM
      DO 530 I=K,N1
  530 C(I+1,NRR)=C(I+1,NRR)-SUM*A(I+1,K)
  540 CONTINUE
C
      RETURN
      END

#endif

